/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jdk;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import io.avaje.applog.AppLog;
import io.avaje.jex.AppLifecycle;
import io.avaje.jex.Jex;
import io.avaje.jex.JexConfig;
import io.avaje.jex.core.SpiServiceManager;
import io.avaje.jex.jdk.CtxServiceManager;
import io.avaje.jex.jdk.JdkJexServer;
import io.avaje.jex.jdk.RoutingHandler;
import io.avaje.jex.routes.SpiRoutes;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class JdkServerStart {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.jex");

    public Jex.Server start(Jex jex, SpiRoutes routes, SpiServiceManager serviceManager) {
        try {
            HttpServer server;
            JexConfig config = jex.config();
            InetSocketAddress socketAddress = JdkServerStart.createSocketAddress(config);
            HttpsConfigurator https = config.httpsConfig();
            if (https != null) {
                HttpsServer httpsServer = HttpsServer.create(socketAddress, config.socketBacklog());
                httpsServer.setHttpsConfigurator(https);
                server = httpsServer;
            } else {
                server = HttpServer.create(socketAddress, config.socketBacklog());
            }
            String scheme = config.scheme();
            String contextPath = config.contextPath();
            CtxServiceManager manager = new CtxServiceManager(serviceManager, scheme, contextPath);
            RoutingHandler handler = new RoutingHandler(routes, manager, config.compression());
            server.setExecutor(config.executor());
            server.createContext(contextPath, handler);
            server.start();
            jex.lifecycle().status(AppLifecycle.Status.STARTED);
            log.log(System.Logger.Level.INFO, "started com.sun.net.httpserver.HttpServer on port {0}://{1}", scheme, socketAddress);
            return new JdkJexServer(server, jex.lifecycle(), handler);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static InetSocketAddress createSocketAddress(JexConfig config) throws UnknownHostException {
        InetAddress inetAddress = config.host() == null ? null : InetAddress.getByName(config.host());
        return new InetSocketAddress(inetAddress, config.port());
    }
}

