/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.http.sse;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import io.avaje.jex.http.BadRequestException;
import io.avaje.jex.http.Context;
import io.avaje.jex.http.ExchangeHandler;
import io.avaje.jex.http.sse.SseClient;
import io.avaje.jex.http.sse.SseClientImpl;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;

final class SseHandler
implements ExchangeHandler {
    private static final String TEXT_EVENT_STREAM = "text/event-stream";
    private final Consumer<SseClient> consumer;

    SseHandler(Consumer<SseClient> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void handle(Context ctx) throws Exception {
        if (!TEXT_EVENT_STREAM.equals(ctx.header("Accept"))) {
            throw new BadRequestException("SSE Requests must have an 'Accept: text/event-stream' header");
        }
        HttpExchange exchange = ctx.exchange();
        Headers headers = exchange.getResponseHeaders();
        headers.add("Content-type", TEXT_EVENT_STREAM);
        headers.add("Content-encoding", "UTF-8");
        headers.add("Connection", "close");
        headers.add("Cache-Control", "no-cache");
        headers.add("X-Accel-Buffering", "no");
        try (SseClientImpl sse = new SseClientImpl(ctx);){
            exchange.sendResponseHeaders(200, 0L);
            this.consumer.accept(sse);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

