/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.Routing;
import io.avaje.jex.http.ExceptionHandler;
import io.avaje.jex.http.ExchangeHandler;
import io.avaje.jex.http.HttpFilter;
import io.avaje.jex.security.Role;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DefaultRouting
implements Routing {
    private final List<Routing.Entry> handlers = new ArrayList<Routing.Entry>();
    private final List<HttpFilter> filters = new ArrayList<HttpFilter>();
    private final Deque<String> pathDeque = new ArrayDeque<String>();
    private final Map<Class<?>, ExceptionHandler<?>> exceptionHandlers = new HashMap();

    DefaultRouting() {
    }

    @Override
    public List<Routing.Entry> handlers() {
        return this.handlers;
    }

    @Override
    public List<HttpFilter> filters() {
        return this.filters;
    }

    @Override
    public Map<Class<?>, ExceptionHandler<?>> errorHandlers() {
        return this.exceptionHandlers;
    }

    private String path(String path) {
        return String.join((CharSequence)"", this.pathDeque) + (String)(path.charAt(0) == '/' || path.isEmpty() ? path : "/" + path);
    }

    private void addEndpoints(String path, Routing.HttpService group) {
        path = ((String)path).charAt(0) == '/' ? path : "/" + (String)path;
        this.pathDeque.addLast((String)path);
        group.add(this);
        this.pathDeque.removeLast();
    }

    @Override
    public Routing add(Routing.HttpService routes) {
        routes.add(this);
        return this;
    }

    @Override
    public Routing addAll(Collection<Routing.HttpService> routes) {
        for (Routing.HttpService route : routes) {
            route.add(this);
        }
        return this;
    }

    @Override
    public <T extends Exception> Routing error(Class<T> type, ExceptionHandler<T> handler) {
        this.exceptionHandlers.put(type, handler);
        return this;
    }

    @Override
    public Routing group(String path, Routing.HttpService group) {
        this.addEndpoints(path, group);
        return this;
    }

    private void add(Routing.Type verb, String path, ExchangeHandler handler, Role ... roles) {
        Entry entry = new Entry(verb, this.path(path), handler, Set.of(roles));
        this.handlers.add(entry);
    }

    @Override
    public Routing get(String path, ExchangeHandler handler, Role ... roles) {
        this.add(Routing.Type.GET, path, handler, roles);
        return this;
    }

    @Override
    public Routing post(String path, ExchangeHandler handler, Role ... roles) {
        this.add(Routing.Type.POST, path, handler, roles);
        return this;
    }

    @Override
    public Routing put(String path, ExchangeHandler handler, Role ... roles) {
        this.add(Routing.Type.PUT, path, handler, roles);
        return this;
    }

    @Override
    public Routing patch(String path, ExchangeHandler handler, Role ... roles) {
        this.add(Routing.Type.PATCH, path, handler, roles);
        return this;
    }

    @Override
    public Routing delete(String path, ExchangeHandler handler, Role ... roles) {
        this.add(Routing.Type.DELETE, path, handler, roles);
        return this;
    }

    @Override
    public Routing head(String path, ExchangeHandler handler, Role ... roles) {
        this.add(Routing.Type.HEAD, path, handler, roles);
        return this;
    }

    @Override
    public Routing trace(String path, ExchangeHandler handler, Role ... roles) {
        this.add(Routing.Type.TRACE, path, handler, roles);
        return this;
    }

    @Override
    public Routing options(String path, ExchangeHandler handler, Role ... roles) {
        this.add(Routing.Type.OPTIONS, path, handler, roles);
        return this;
    }

    @Override
    public Routing filter(HttpFilter handler) {
        this.filters.add(handler);
        return this;
    }

    private static final class Entry
    implements Routing.Entry {
        private final Routing.Type type;
        private final String path;
        private final ExchangeHandler handler;
        private final Set<Role> roles;

        Entry(Routing.Type type, String path, ExchangeHandler handler, Set<Role> roles) {
            this.type = type;
            this.path = path;
            this.handler = handler;
            this.roles = roles;
        }

        @Override
        public Routing.Type getType() {
            return this.type;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public ExchangeHandler getHandler() {
            return this.handler;
        }

        @Override
        public Set<Role> getRoles() {
            return this.roles;
        }
    }
}

