/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.routes.SpiRoutes;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class RouteIndex {
    private final IndexEntry[] entries;
    private final SpiRoutes.Entry[] wildcardEntries;

    RouteIndex(List<SpiRoutes.Entry> wildcards, List<List<SpiRoutes.Entry>> pathEntries) {
        this.wildcardEntries = wildcards.toArray(new SpiRoutes.Entry[0]);
        this.entries = pathEntries.stream().map(RouteIndex::toEntry).toList().toArray(new IndexEntry[0]);
    }

    public String toString() {
        return "RouteIndex{" + Stream.concat(Arrays.stream(this.entries).filter(i -> i.pathEntries.length > 0).map(i -> i.pathEntries).flatMap(Arrays::stream).map(Object::toString), Arrays.stream(this.wildcardEntries).map(Object::toString)).sorted().collect(Collectors.joining(", ")) + "}";
    }

    private static IndexEntry toEntry(List<SpiRoutes.Entry> routeEntries) {
        return new IndexEntry(routeEntries.toArray(new SpiRoutes.Entry[0]));
    }

    private int index(int segmentCount) {
        return Math.min(segmentCount, 5);
    }

    SpiRoutes.Entry match(String pathInfo) {
        SpiRoutes.Entry match = this.entries[this.index(this.segmentCount(pathInfo))].match(pathInfo);
        if (match != null) {
            return match;
        }
        for (SpiRoutes.Entry wildcardEntry : this.wildcardEntries) {
            if (!wildcardEntry.matches(pathInfo)) continue;
            return wildcardEntry;
        }
        return null;
    }

    private int segmentCount(String pathInfo) {
        if ("/".equals(pathInfo)) {
            return 0;
        }
        int last = pathInfo.length() - 1;
        int count = 1;
        for (int i = 1; i < last; ++i) {
            if (pathInfo.charAt(i) != '/') continue;
            ++count;
        }
        return count;
    }

    long activeRequests() {
        long total = 0L;
        for (IndexEntry indexEntry : this.entries) {
            total += indexEntry.activeRequests();
        }
        for (SpiRoutes.Entry entry : this.wildcardEntries) {
            total += entry.activeRequests();
        }
        return total;
    }

    private static final class IndexEntry {
        private final SpiRoutes.Entry[] pathEntries;

        IndexEntry(SpiRoutes.Entry[] pathEntries) {
            this.pathEntries = pathEntries;
        }

        public String toString() {
            return Arrays.toString(this.pathEntries);
        }

        SpiRoutes.Entry match(String pathInfo) {
            for (SpiRoutes.Entry entry : this.pathEntries) {
                if (!entry.matches(pathInfo)) continue;
                return entry;
            }
            return null;
        }

        long activeRequests() {
            long total = 0L;
            for (SpiRoutes.Entry entry : this.pathEntries) {
                total += entry.activeRequests();
            }
            return total;
        }
    }
}

