/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core.json;

import io.avaje.jex.spi.JsonService;
import io.avaje.json.JsonWriter;
import io.avaje.jsonb.JsonType;
import io.avaje.jsonb.Jsonb;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Iterator;

public final class JsonbJsonService
implements JsonService {
    private final Jsonb jsonb;

    public JsonbJsonService() {
        this.jsonb = Jsonb.builder().build();
    }

    public JsonbJsonService(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    @Override
    public <T> T fromJson(Class<T> clazz, InputStream is) {
        return (T)this.jsonb.type(clazz).fromJson(is);
    }

    @Override
    public <T> T fromJson(Type clazz, InputStream is) {
        return (T)this.jsonb.type(clazz).fromJson(is);
    }

    @Override
    public void toJson(Object bean, OutputStream os) {
        this.jsonb.toJson(bean, os);
    }

    public <T> void toJsonStream(Iterator<T> iterator, OutputStream os) {
        try (JsonWriter writer = this.jsonb.writer(os);){
            writer.pretty(false);
            if (iterator.hasNext()) {
                T first = iterator.next();
                JsonType type = this.jsonb.typeOf(first);
                type.toJson(first, writer);
                writer.writeNewLine();
                while (iterator.hasNext()) {
                    type.toJson(iterator.next(), writer);
                    writer.writeNewLine();
                }
            }
        }
    }
}

