/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.core.JdkContext;
import io.avaje.jex.http.Context;
import io.avaje.jex.http.ExceptionHandler;
import io.avaje.jex.http.HttpResponseException;
import io.avaje.jex.http.HttpStatus;
import io.avaje.jex.http.InternalServerErrorException;
import java.util.Map;

final class ExceptionManager {
    private static final String APPLICATION_JSON = "application/json";
    private static final System.Logger log = System.getLogger("io.avaje.jex");
    private final Map<Class<?>, ExceptionHandler<?>> handlers;

    ExceptionManager(Map<Class<?>, ExceptionHandler<?>> handlers) {
        this.handlers = handlers;
    }

    ExceptionHandler<Exception> find(Class<?> exceptionType) {
        Class<?> type = exceptionType;
        do {
            ExceptionHandler<Exception> handler;
            if ((handler = this.handlers.get(type)) == null) continue;
            return handler;
        } while ((type = type.getSuperclass()) != null);
        return null;
    }

    void handle(JdkContext ctx, Exception e) {
        ExceptionHandler<Exception> handler = this.find(e.getClass());
        if (handler != null) {
            try {
                handler.handle(ctx, e);
            }
            catch (Exception ex) {
                this.unhandledException(ctx, ex);
            }
        } else if (e instanceof HttpResponseException) {
            HttpResponseException ex = (HttpResponseException)e;
            this.defaultHandling(ctx, ex);
        } else {
            this.unhandledException(ctx, e);
        }
    }

    private void unhandledException(JdkContext ctx, Exception e) {
        log.log(System.Logger.Level.ERROR, "Uncaught exception", (Throwable)e);
        this.defaultHandling(ctx, new InternalServerErrorException("Internal Server Error"));
    }

    private void defaultHandling(JdkContext ctx, HttpResponseException exception) {
        if (ctx.responseSent()) {
            return;
        }
        ctx.status(exception.status());
        Object jsonResponse = exception.jsonResponse();
        if (exception.status() == HttpStatus.FOUND_302.status()) {
            ctx.performRedirect();
        } else if (jsonResponse != null) {
            ctx.json(jsonResponse);
        } else if (this.useJson(ctx)) {
            ctx.contentType(APPLICATION_JSON).write(this.asJsonContent(exception));
        } else {
            ctx.text(exception.getMessage());
        }
    }

    private String asJsonContent(HttpResponseException e) {
        return "{\"title\": " + this.jsonEscape(e.getMessage()) + ", \"status\": " + e.status() + "}";
    }

    private String jsonEscape(String message) {
        return message;
    }

    private boolean useJson(Context ctx) {
        String acceptHeader = ctx.header("Accept");
        return acceptHeader != null && acceptHeader.contains(APPLICATION_JSON) || APPLICATION_JSON.equals(ctx.responseHeader("Content-Type"));
    }
}

