/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.HttpFilter;
import io.avaje.jex.Routing;
import io.avaje.jex.jdk.JdkFilter;
import io.avaje.jex.routes.PathParser;
import io.avaje.jex.routes.RouteEntry;
import io.avaje.jex.routes.RouteIndex;
import io.avaje.jex.routes.Routes;
import io.avaje.jex.routes.SpiRoutes;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public final class RoutesBuilder {
    private final EnumMap<Routing.Type, RouteIndex> typeMap = new EnumMap(Routing.Type.class);
    private final boolean ignoreTrailingSlashes;
    private final List<JdkFilter> filters = new ArrayList<JdkFilter>();

    public RoutesBuilder(Routing routing, boolean ignoreTrailingSlashes) {
        this.ignoreTrailingSlashes = ignoreTrailingSlashes;
        for (Routing.Entry entry : routing.handlers()) {
            this.typeMap.computeIfAbsent(entry.getType(), h -> new RouteIndex()).add(this.convert(entry));
        }
        for (HttpFilter httpFilter : routing.filters()) {
            this.filters.add(new JdkFilter(httpFilter));
        }
    }

    private SpiRoutes.Entry convert(Routing.Entry handler) {
        PathParser pathParser = new PathParser(handler.getPath(), this.ignoreTrailingSlashes);
        return new RouteEntry(pathParser, handler.getHandler(), handler.getRoles());
    }

    public SpiRoutes build() {
        return new Routes(this.typeMap, this.filters);
    }
}

