/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jdk;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import io.avaje.applog.AppLog;
import io.avaje.jex.AppLifecycle;
import io.avaje.jex.Jex;
import io.avaje.jex.core.SpiServiceManager;
import io.avaje.jex.jdk.BaseHandler;
import io.avaje.jex.jdk.CtxServiceManager;
import io.avaje.jex.jdk.JdkJexServer;
import io.avaje.jex.jdk.RoutingFilter;
import io.avaje.jex.routes.SpiRoutes;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;

public final class JdkServerStart {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.jex");

    public Jex.Server start(Jex jex, SpiRoutes routes, SpiServiceManager serviceManager) {
        try {
            String scheme;
            HttpServer server;
            InetSocketAddress port = new InetSocketAddress(jex.config().port());
            SSLContext sslContext = jex.config().sslContext();
            if (sslContext != null) {
                HttpsServer httpsServer = HttpsServer.create(port, 0);
                httpsServer.setHttpsConfigurator(new HttpsConfigurator(sslContext));
                server = httpsServer;
                scheme = "https";
            } else {
                scheme = "http";
                server = HttpServer.create(port, 0);
            }
            CtxServiceManager manager = new CtxServiceManager(serviceManager, scheme, "");
            BaseHandler handler = new BaseHandler(routes);
            HttpContext context = server.createContext("/", handler);
            context.getFilters().add(new RoutingFilter(routes, manager, jex.config().compression()));
            context.getFilters().addAll(routes.filters());
            server.setExecutor(jex.config().executor());
            server.start();
            jex.lifecycle().status(AppLifecycle.Status.STARTED);
            log.log(System.Logger.Level.INFO, "started com.sun.net.httpserver.HttpServer on port %s://%s".formatted(scheme, port));
            return new JdkJexServer(server, jex.lifecycle(), handler);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

