/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.compression;

import io.avaje.jex.Context;
import io.avaje.jex.compression.CompressionConfig;
import io.avaje.jex.compression.Compressor;
import io.avaje.jex.spi.SpiContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Optional;

public class CompressedOutputStream
extends OutputStream {
    private final int minSizeForCompression;
    private final CompressionConfig compression;
    private final Context ctx;
    private final OutputStream originStream;
    private OutputStream compressedStream;
    private boolean compressionDecided;

    public CompressedOutputStream(CompressionConfig compression, SpiContext ctx, OutputStream originStream) {
        this.minSizeForCompression = compression.minSizeForCompression();
        this.compression = compression;
        this.ctx = ctx;
        this.originStream = originStream;
    }

    private void decideCompression(int length) throws IOException {
        if (!this.compressionDecided) {
            Optional<Compressor> compressor;
            boolean compressionAllowed;
            String encoding = this.ctx.responseHeader("Content-Encoding");
            if (encoding != null) {
                this.compressedStream = this.findMatchingCompressor(encoding).orElseThrow(() -> new IllegalStateException("No compressor found for Content-Encoding:" + encoding)).compress(this.originStream);
            }
            boolean bl = compressionAllowed = this.compressedStream == null && this.compression.allowsForCompression(this.ctx.contentType());
            if (compressionAllowed && length >= this.minSizeForCompression && (compressor = this.findMatchingCompressor(this.ctx.header("Accept-Encoding"))).isPresent()) {
                this.compressedStream = compressor.get().compress(this.originStream);
                this.ctx.header("Content-Encoding", compressor.get().encoding());
            }
            this.compressionDecided = true;
        }
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.decideCompression(length);
        (this.compressedStream != null ? this.compressedStream : this.originStream).write(bytes, offset, length);
    }

    @Override
    public void write(int byteVal) throws IOException {
        this.decideCompression(1);
        (this.compressedStream != null ? this.compressedStream : this.originStream).write(byteVal);
    }

    @Override
    public void close() throws IOException {
        if (this.compressedStream != null) {
            this.compressedStream.close();
        }
        this.originStream.close();
    }

    private Optional<Compressor> findMatchingCompressor(String acceptedEncoding) {
        if (acceptedEncoding != null) {
            return Arrays.stream(acceptedEncoding.split(",")).map(this.compression::forType).findFirst();
        }
        return Optional.empty();
    }
}

