/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.config.Config;
import io.avaje.inject.BeanScope;
import io.avaje.jex.Jex;
import io.avaje.jex.JexConfig;

final class BootJexState {
    private static State state;

    BootJexState() {
    }

    static void start(BeanScope beanScope) {
        state = new BootJexState().create(beanScope);
    }

    static void stop() {
        state.stop();
    }

    static void restart() {
        state.restart();
    }

    State create(BeanScope beanScope) {
        Jex jex = beanScope.getOptional(Jex.class).orElse(Jex.create());
        jex.configureWith(beanScope);
        JexConfig config = jex.config();
        int port = config.port();
        config.port(Config.getInt((String)"server.port", (int)port));
        jex.lifecycle().onShutdown(() -> ((BeanScope)beanScope).close());
        return new State(jex.start());
    }

    private static final class State {
        private final Jex.Server server;

        State(Jex.Server server) {
            this.server = server;
        }

        void stop() {
            this.server.shutdown();
        }

        public void restart() {
            this.server.restart();
        }
    }
}

