/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import io.avaje.jex.AppLifecycle;
import io.avaje.jex.Jex;
import io.avaje.jex.JexConfig;
import io.avaje.jex.core.CoreServiceLoader;
import io.avaje.jex.core.HealthPlugin;
import io.avaje.jex.core.JdkJexServer;
import io.avaje.jex.core.RoutingHandler;
import io.avaje.jex.core.SpiServiceManager;
import io.avaje.jex.routes.RoutesBuilder;
import io.avaje.jex.routes.SpiRoutes;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class BootstrapServer {
    private static final System.Logger log = System.getLogger("io.avaje.jex");

    public static Jex.Server start(Jex jex) {
        JexConfig config = jex.config();
        if (config.health()) {
            jex.plugin(new HealthPlugin());
        }
        if (config.useSpiPlugins()) {
            CoreServiceLoader.plugins().forEach(p -> p.apply(jex));
        }
        SpiRoutes routes = new RoutesBuilder(jex.routing(), config).build();
        return BootstrapServer.start(jex, routes);
    }

    static Jex.Server start(Jex jex, SpiRoutes routes) {
        try {
            HttpServer server;
            JexConfig config = jex.config();
            InetSocketAddress socketAddress = BootstrapServer.createSocketAddress(config);
            HttpsConfigurator https = config.httpsConfig();
            if (https != null) {
                HttpsServer httpsServer = HttpsServer.create(socketAddress, config.socketBacklog());
                httpsServer.setHttpsConfigurator(https);
                server = httpsServer;
            } else {
                server = HttpServer.create(socketAddress, config.socketBacklog());
            }
            String scheme = config.scheme();
            String contextPath = config.contextPath();
            SpiServiceManager serviceManager = SpiServiceManager.create(jex);
            RoutingHandler handler = new RoutingHandler(routes, serviceManager, config.compression());
            server.setExecutor(config.executor());
            server.createContext(contextPath, handler);
            server.start();
            jex.lifecycle().status(AppLifecycle.Status.STARTED);
            log.log(System.Logger.Level.INFO, "started com.sun.net.httpserver.HttpServer on port {0}://{1}", scheme, socketAddress);
            log.log(System.Logger.Level.DEBUG, routes);
            return new JdkJexServer(server, jex.lifecycle(), handler);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static InetSocketAddress createSocketAddress(JexConfig config) throws UnknownHostException {
        InetAddress inetAddress = config.host() == null ? null : InetAddress.getByName(config.host());
        return new InetSocketAddress(inetAddress, config.port());
    }
}

