/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.routes.PathSegment;
import io.avaje.jex.routes.PathSegmentParser;
import io.avaje.jex.routes.RegBuilder;
import io.avaje.jex.routes.UrlDecode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PathParser {
    private final String rawPath;
    private final List<String> paramNames = new ArrayList<String>();
    private final Pattern matchRegex;
    private final Pattern pathParamRegex;
    private final boolean multiSlash;
    private final boolean literal;
    private int segmentCount;

    PathParser(String path, boolean ignoreTrailingSlashes) {
        this.rawPath = path;
        RegBuilder regBuilder = new RegBuilder();
        for (String rawSeg : path.split("/")) {
            if (rawSeg.isEmpty()) continue;
            ++this.segmentCount;
            regBuilder.add(this.parseSegment(rawSeg), this.paramNames);
        }
        if (!ignoreTrailingSlashes && path.endsWith("/")) {
            ++this.segmentCount;
            regBuilder.trailingSlash();
        }
        this.matchRegex = regBuilder.matchRegex();
        this.pathParamRegex = regBuilder.extractRegex();
        this.multiSlash = regBuilder.multiSlash();
        this.literal = this.segmentCount > 1 && regBuilder.literal();
    }

    boolean matches(String url) {
        return this.matchRegex.matcher(url).matches();
    }

    Map<String, String> extractPathParams(String uri) {
        LinkedHashMap<String, String> pathMap = new LinkedHashMap<String, String>();
        List<String> values = this.values(uri);
        for (int i = 0; i < values.size(); ++i) {
            String name = this.paramNames.get(i);
            if (name == null) continue;
            pathMap.put(name, UrlDecode.decode(values.get(i)));
        }
        return pathMap;
    }

    private List<String> values(String uri) {
        Matcher matcher = this.pathParamRegex.matcher(uri);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        int i = matcher.groupCount();
        ArrayList<String> values = new ArrayList<String>(i);
        for (int j = 1; j <= i; ++j) {
            values.add(matcher.group(j));
        }
        return values;
    }

    private PathSegment parseSegment(String segment) {
        return PathSegmentParser.parse(segment, this.rawPath);
    }

    String raw() {
        return this.rawPath;
    }

    int segmentCount() {
        return this.segmentCount;
    }

    boolean multiSlash() {
        return this.multiSlash;
    }

    boolean literal() {
        return this.literal;
    }
}

