/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.Context;
import io.avaje.jex.Jex;
import io.avaje.jex.Routing;
import io.avaje.jex.core.BufferedOutStream;
import io.avaje.jex.core.CoreServiceLoader;
import io.avaje.jex.core.ExceptionManager;
import io.avaje.jex.core.HttpMethodMap;
import io.avaje.jex.core.JdkContext;
import io.avaje.jex.core.TemplateManager;
import io.avaje.jex.core.json.JacksonJsonService;
import io.avaje.jex.core.json.JsonbJsonService;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.TemplateRender;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

final class SpiServiceManager {
    private static final System.Logger log = System.getLogger("io.avaje.jex");
    static final String UTF_8 = "UTF-8";
    private final HttpMethodMap methodMap = new HttpMethodMap();
    private final JsonService jsonService;
    private final ExceptionManager exceptionHandler;
    private final TemplateManager templateManager;
    private final String scheme;
    private final String contextPath;

    static SpiServiceManager create(Jex jex) {
        return new Builder(jex).build();
    }

    SpiServiceManager(JsonService jsonService, ExceptionManager manager, TemplateManager templateManager, String scheme, String contextPath) {
        this.jsonService = jsonService;
        this.exceptionHandler = manager;
        this.templateManager = templateManager;
        this.scheme = scheme;
        this.contextPath = contextPath;
    }

    OutputStream createOutputStream(JdkContext jdkContext) {
        return new BufferedOutStream(jdkContext);
    }

    <T> T fromJson(Class<T> type, InputStream is) {
        return this.jsonService.fromJson(type, is);
    }

    <T> T fromJson(Type type, InputStream is) {
        return this.jsonService.fromJson(type, is);
    }

    void toJson(Object bean, OutputStream os) {
        this.jsonService.toJson(bean, os);
    }

    <E> void toJsonStream(Stream<E> stream, OutputStream os) {
        try (Stream<E> stream2 = stream;){
            this.jsonService.toJsonStream(stream.iterator(), os);
        }
    }

    <E> void toJsonStream(Iterator<E> iterator, OutputStream os) {
        try {
            this.jsonService.toJsonStream(iterator, os);
        }
        finally {
            this.maybeClose(iterator);
        }
    }

    void maybeClose(Object iterator) {
        if (iterator instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)iterator;
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error closing iterator " + String.valueOf(iterator), e);
            }
        }
    }

    Routing.Type lookupRoutingType(String method) {
        return this.methodMap.get(method);
    }

    void handleException(JdkContext ctx, Exception e) {
        this.exceptionHandler.handle(ctx, e);
    }

    void render(Context ctx, String name, Map<String, Object> model) {
        this.templateManager.render(ctx, name, model);
    }

    String requestCharset(Context ctx) {
        return SpiServiceManager.parseCharset(ctx.header("Content-Type"));
    }

    static String parseCharset(String header) {
        if (header != null) {
            for (String val : header.split(";")) {
                if (!(val = val.trim()).regionMatches(true, 0, "charset", 0, "charset".length())) continue;
                return val.split("=")[1].trim();
            }
        }
        return UTF_8;
    }

    Map<String, List<String>> formParamMap(Context ctx, String charset) {
        return this.parseParamMap(ctx.body(), charset);
    }

    Map<String, List<String>> parseParamMap(String body, String charset) {
        if (body == null || body.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            for (String pair : body.split("&")) {
                String[] split1 = pair.split("=", 2);
                String key = URLDecoder.decode(split1[0], charset);
                String val = split1.length > 1 ? URLDecoder.decode(split1[1], charset) : "";
                map.computeIfAbsent(key, s -> new ArrayList()).add(val);
            }
            return map;
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    String scheme() {
        return this.scheme;
    }

    String contextPath() {
        return this.contextPath;
    }

    private static final class Builder {
        private final Jex jex;

        Builder(Jex jex) {
            this.jex = jex;
        }

        SpiServiceManager build() {
            return new SpiServiceManager(this.initJsonService(), new ExceptionManager(this.jex.routing().errorHandlers()), this.initTemplateMgr(), this.jex.config().scheme(), this.jex.config().contextPath());
        }

        JsonService initJsonService() {
            JsonService jsonService = this.jex.config().jsonService();
            if (jsonService != null) {
                return jsonService;
            }
            JsonService json = CoreServiceLoader.jsonService().orElseGet(this::defaultJsonService);
            if (json == null) {
                log.log(System.Logger.Level.WARNING, "No Json library configured");
            }
            return json;
        }

        JsonService defaultJsonService() {
            if (this.detectJackson()) {
                try {
                    return new JacksonJsonService();
                }
                catch (IllegalAccessError errorNotInModulePath) {
                    log.log(System.Logger.Level.DEBUG, "Not using Jackson due to module path {0}", errorNotInModulePath.getMessage());
                }
            }
            return this.detectJsonb() ? new JsonbJsonService() : null;
        }

        boolean detectJackson() {
            return this.detectTypeExists("com.fasterxml.jackson.databind.ObjectMapper");
        }

        boolean detectJsonb() {
            return this.detectTypeExists("io.avaje.jsonb.Jsonb");
        }

        private boolean detectTypeExists(String className) {
            try {
                Class.forName(className);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        TemplateManager initTemplateMgr() {
            TemplateManager mgr = new TemplateManager();
            mgr.register(this.jex.config().renderers());
            for (TemplateRender render : CoreServiceLoader.getRenders()) {
                mgr.registerDefault(render);
            }
            return mgr;
        }
    }
}

