/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.Context;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

final class DCookie
implements Context.Cookie {
    private static final ZonedDateTime EXPIRED = ZonedDateTime.of(LocalDateTime.of(2000, 1, 1, 0, 0, 0), ZoneId.of("GMT"));
    private static final DateTimeFormatter RFC_1123_DATE_TIME = DateTimeFormatter.RFC_1123_DATE_TIME;
    private static final String PARAM_SEPARATOR = "; ";
    private final String name;
    private final String value;
    private String domain;
    private ZonedDateTime expires;
    private Duration maxAge;
    private String path;
    private Context.Cookie.SameSite sameSite;
    private boolean secure;
    private boolean httpOnly;
    private boolean partitioned;

    private DCookie(String name, String value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name required");
        }
        this.name = name;
        this.value = value;
    }

    static Context.Cookie expired(String name) {
        return new DCookie(name, "").expires(EXPIRED);
    }

    static Context.Cookie of(String name, String value) {
        return new DCookie(name, value);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public Context.Cookie domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public Duration maxAge() {
        return this.maxAge;
    }

    @Override
    public Context.Cookie maxAge(Duration maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Override
    public ZonedDateTime expires() {
        return this.expires;
    }

    @Override
    public Context.Cookie expires(ZonedDateTime expires) {
        this.expires = expires;
        return this;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Context.Cookie path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public boolean secure() {
        return this.secure;
    }

    @Override
    public Context.Cookie secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public boolean httpOnly() {
        return this.httpOnly;
    }

    @Override
    public Context.Cookie httpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    @Override
    public boolean partitioned() {
        return this.partitioned;
    }

    @Override
    public Context.Cookie partitioned(boolean partitioned) {
        this.partitioned = partitioned;
        return this;
    }

    @Override
    public Context.Cookie.SameSite sameSite() {
        return this.sameSite;
    }

    @Override
    public Context.Cookie sameSite(Context.Cookie.SameSite sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(60);
        result.append(this.name).append('=').append(this.value);
        if (this.expires != null) {
            result.append(PARAM_SEPARATOR).append("Expires=").append(this.expires.format(RFC_1123_DATE_TIME));
        }
        if (this.maxAge != null && !this.maxAge.isNegative() && !this.maxAge.isZero()) {
            result.append(PARAM_SEPARATOR).append("Max-Age=").append(this.maxAge.getSeconds());
        }
        if (this.domain != null) {
            result.append(PARAM_SEPARATOR).append("Domain=").append(this.domain);
        }
        if (this.path != null) {
            result.append(PARAM_SEPARATOR).append("Path=").append(this.path);
        }
        if (this.sameSite != null) {
            result.append(PARAM_SEPARATOR).append("SameSite=").append((Object)this.sameSite);
        }
        if (this.secure) {
            result.append(PARAM_SEPARATOR).append("Secure");
        }
        if (this.httpOnly) {
            result.append(PARAM_SEPARATOR).append("HttpOnly");
        }
        if (this.partitioned) {
            result.append(PARAM_SEPARATOR).append("Partitioned");
        }
        return result.toString();
    }
}

