/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.config.Config;
import io.avaje.inject.BeanScope;
import io.avaje.jex.Jex;
import io.avaje.jex.JexConfig;

final class BootJexState {
    private static State state;

    BootJexState() {
    }

    static void start(BeanScope beanScope) {
        state = new BootJexState().create(beanScope);
    }

    static void stop() {
        state.stop();
    }

    State create(BeanScope beanScope) {
        Jex jex = beanScope.getOptional(Jex.class).orElse(Jex.create());
        jex.configureWith(beanScope);
        JexConfig config = jex.config();
        config.port(Config.getInt((String)"server.port", (int)config.port()));
        config.contextPath(Config.get((String)"server.context.path", (String)config.contextPath()));
        config.host(Config.get((String)"server.context.host", (String)config.host()));
        jex.lifecycle().onShutdown(() -> ((BeanScope)beanScope).close());
        return new State(jex.start());
    }

    private static final class State {
        private final Jex.Server server;

        State(Jex.Server server) {
            this.server = server;
        }

        void stop() {
            this.server.shutdown();
        }
    }
}

