/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.Context;
import io.avaje.jex.TemplateRender;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TemplateManager {
    private final Map<String, TemplateRender> map = new HashMap<String, TemplateRender>();
    private final Set<Class<?>> renderTypes = new HashSet();

    public void register(Map<String, TemplateRender> source) {
        this.map.putAll(source);
        this.map.values().stream().forEach(templateRender -> this.renderTypes.add(templateRender.getClass()));
    }

    public void registerDefault(TemplateRender render) {
        if (!this.renderTypes.contains(render.getClass())) {
            for (String extension : render.defaultExtensions()) {
                if (this.map.containsKey(extension)) continue;
                this.map.put(extension, render);
            }
        }
    }

    public void register(String extn, TemplateRender renderer) {
        this.map.put(extn, renderer);
    }

    public void render(Context ctx, String name, Map<String, Object> model) {
        String extn = this.extension(name);
        if (extn == null) {
            throw new IllegalArgumentException("No extension, not handled yet - " + name);
        }
        TemplateRender renderer = this.map.get(extn);
        if (renderer == null) {
            throw new IllegalArgumentException("No renderer registered for extension - " + extn);
        }
        renderer.render(ctx, name, model);
    }

    private String extension(String name) {
        int pos = name.indexOf(46);
        return pos == -1 ? null : name.substring(pos + 1);
    }
}

