/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.SpiContext;
import io.avaje.jsonb.JsonType;
import io.avaje.jsonb.JsonWriter;
import io.avaje.jsonb.Jsonb;
import java.util.Iterator;

public class JsonbJsonService
implements JsonService {
    private final Jsonb jsonb;

    public JsonbJsonService() {
        this.jsonb = Jsonb.builder().build();
    }

    public JsonbJsonService(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    @Override
    public <T> T jsonRead(Class<T> clazz, SpiContext ctx) {
        return (T)this.jsonb.type(clazz).fromJson(ctx.inputStream());
    }

    @Override
    public void jsonWrite(Object bean, SpiContext ctx) {
        this.jsonb.toJson(bean, ctx.outputStream());
    }

    public <T> void jsonWriteStream(Iterator<T> iterator, SpiContext ctx) {
        try (JsonWriter writer = this.jsonb.writer(ctx.outputStream());){
            writer.pretty(false);
            if (iterator.hasNext()) {
                T first = iterator.next();
                JsonType type = this.jsonb.typeOf(first);
                type.toJson(first, writer);
                writer.writeNewLine();
                while (iterator.hasNext()) {
                    type.toJson(iterator.next(), writer);
                    writer.writeNewLine();
                }
            }
        }
    }
}

