/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.SpiContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;

public class JacksonJsonService
implements JsonService {
    private final ObjectMapper mapper;

    public JacksonJsonService() {
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JacksonJsonService(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> T jsonRead(Class<T> clazz, SpiContext ctx) {
        try {
            return (T)this.mapper.readValue(ctx.inputStream(), clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void jsonWrite(Object bean, SpiContext ctx) {
        try {
            OutputStream os = ctx.outputStream();
            try (JsonGenerator generator = this.mapper.createGenerator(os);){
                generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                generator.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
                generator.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
                this.mapper.writeValue(generator, bean);
                generator.flush();
            }
            os.flush();
            os.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> void jsonWriteStream(Iterator<T> iterator, SpiContext ctx) {
        try {
            JsonGenerator generator = this.mapper.createGenerator(ctx.outputStream());
            generator.setPrettyPrinter(null);
            try {
                while (iterator.hasNext()) {
                    try {
                        this.mapper.writeValue(generator, iterator.next());
                        generator.writeRaw('\n');
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                        return;
                    }
                }
            }
            finally {
                generator.flush();
                generator.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

