/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.applog.AppLog;
import io.avaje.jex.ErrorHandling;
import io.avaje.jex.ExceptionHandler;
import io.avaje.jex.http.HttpResponseException;
import io.avaje.jex.http.InternalServerErrorResponse;
import io.avaje.jex.http.RedirectResponse;
import io.avaje.jex.spi.SpiContext;

class ExceptionManager {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.jex");
    private final ErrorHandling errorHandling;

    ExceptionManager(ErrorHandling errorHandling) {
        this.errorHandling = errorHandling;
    }

    void handle(SpiContext ctx, Exception e) {
        ExceptionHandler<Exception> handler;
        if (!this.isRedirect(e)) {
            if (ctx.isCommitted()) {
                log.log(System.Logger.Level.WARNING, "Response is already committed when handling exception", (Throwable)e);
                throw new InternalServerErrorResponse("Response already committed on error " + e);
            }
            ctx.reset();
        }
        if ((handler = this.errorHandling.find(e.getClass())) != null) {
            handler.handle(e, ctx);
        } else if (this.canHandle(e)) {
            this.defaultHandling(ctx, e);
        } else {
            this.unhandledException(ctx, e);
        }
    }

    private void unhandledException(SpiContext ctx, Exception e) {
        log.log(System.Logger.Level.WARNING, "Uncaught exception", (Throwable)e);
        this.defaultHandling(ctx, new InternalServerErrorResponse());
    }

    private boolean canHandle(Exception e) {
        return HttpResponseException.class.isAssignableFrom(e.getClass());
    }

    private boolean isRedirect(Exception e) {
        return RedirectResponse.class.isAssignableFrom(e.getClass());
    }

    private void defaultHandling(SpiContext ctx, Exception exception) {
        HttpResponseException e = this.unwrap(exception);
        ctx.status(e.getStatus());
        if (this.isRedirect(e)) {
            ctx.performRedirect();
        } else if (this.useJson(ctx)) {
            ctx.contentType("application/json").write(this.asJsonContent(e));
        } else {
            ctx.text(this.asTextContent(e));
        }
    }

    private String asTextContent(HttpResponseException e) {
        return e.getMessage();
    }

    private String asJsonContent(HttpResponseException e) {
        return "{\"title\": " + this.jsonEscape(e.getMessage()) + ", \"status\": " + e.getStatus() + this.jsonDetails(e) + "}";
    }

    private String jsonEscape(String message) {
        return message;
    }

    private String jsonDetails(HttpResponseException e) {
        return "";
    }

    private HttpResponseException unwrap(Exception e) {
        return (HttpResponseException)e;
    }

    private boolean useJson(SpiContext ctx) {
        String acceptHeader = ctx.header("Accept");
        return acceptHeader != null && acceptHeader.contains("application/json") || "application/json".equals(ctx.responseHeader("Content-Type"));
    }
}

