/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.inject.BeanScope;
import io.avaje.jex.AccessManager;
import io.avaje.jex.AppLifecycle;
import io.avaje.jex.DJexConfig;
import io.avaje.jex.DefaultErrorHandling;
import io.avaje.jex.DefaultLifecycle;
import io.avaje.jex.DefaultRouting;
import io.avaje.jex.DefaultStaticFileConfig;
import io.avaje.jex.ErrorHandling;
import io.avaje.jex.ExceptionHandler;
import io.avaje.jex.Jex;
import io.avaje.jex.JexConfig;
import io.avaje.jex.Plugin;
import io.avaje.jex.Routing;
import io.avaje.jex.ServerConfig;
import io.avaje.jex.StaticFileConfig;
import io.avaje.jex.TemplateRender;
import io.avaje.jex.core.HealthPlugin;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.SpiRoutes;
import io.avaje.jex.spi.SpiRoutesProvider;
import io.avaje.jex.spi.SpiServiceManager;
import io.avaje.jex.spi.SpiServiceManagerProvider;
import io.avaje.jex.spi.SpiStartServer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;

final class DJex
implements Jex {
    private final Routing routing = new DefaultRouting();
    private final ErrorHandling errorHandling = new DefaultErrorHandling();
    private final AppLifecycle lifecycle = new DefaultLifecycle();
    private final StaticFileConfig staticFiles;
    private final Map<Class<?>, Object> attributes = new HashMap();
    private final DJexConfig config = new DJexConfig();
    private ServerConfig serverConfig;

    DJex() {
        this.staticFiles = new DefaultStaticFileConfig(this);
    }

    @Override
    public DJexConfig config() {
        return this.config;
    }

    @Override
    public <T> Jex attribute(Class<T> cls, T instance) {
        this.attributes.put(cls, instance);
        return this;
    }

    @Override
    public <T> T attribute(Class<T> cls) {
        return (T)this.attributes.get(cls);
    }

    @Override
    public Jex errorHandling(ErrorHandling.Service service) {
        service.add(this.errorHandling);
        return this;
    }

    @Override
    public ErrorHandling errorHandling() {
        return this.errorHandling;
    }

    @Override
    public ServerConfig serverConfig() {
        return this.serverConfig;
    }

    @Override
    public Jex serverConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        return this;
    }

    @Override
    public Jex routing(Routing.Service routes) {
        this.routing.add(routes);
        return this;
    }

    @Override
    public Jex routing(Collection<Routing.Service> routes) {
        this.routing.addAll(routes);
        return this;
    }

    @Override
    public Routing routing() {
        return this.routing;
    }

    @Override
    public Jex accessManager(AccessManager accessManager) {
        this.config.accessManager(accessManager);
        return this;
    }

    @Override
    public Jex jsonService(JsonService jsonService) {
        this.config.jsonService(jsonService);
        return this;
    }

    @Override
    public Jex plugin(Plugin plugin) {
        plugin.apply(this);
        return this;
    }

    @Override
    public Jex configureWith(BeanScope beanScope) {
        this.lifecycle.onShutdown(() -> ((BeanScope)beanScope).close());
        for (Plugin plugin : beanScope.list(Plugin.class)) {
            plugin.apply(this);
        }
        for (ErrorHandling.Service service : beanScope.list(ErrorHandling.Service.class)) {
            service.add(this.errorHandling);
        }
        this.routing.addAll(beanScope.list(Routing.Service.class));
        beanScope.getOptional(JsonService.class).ifPresent(this::jsonService);
        beanScope.getOptional(AccessManager.class).ifPresent(this::accessManager);
        return this;
    }

    @Override
    public Jex configure(Consumer<JexConfig> configure) {
        configure.accept(this.config);
        return this;
    }

    @Override
    public <T extends Exception> Jex exception(Class<T> exceptionClass, ExceptionHandler<T> handler) {
        this.errorHandling.exception(exceptionClass, handler);
        return this;
    }

    @Override
    public Jex port(int port) {
        this.config.port(port);
        return this;
    }

    @Override
    public Jex context(String contextPath) {
        this.config.contextPath(contextPath);
        return this;
    }

    @Override
    public StaticFileConfig staticFiles() {
        return this.staticFiles;
    }

    @Override
    public Jex register(TemplateRender renderer, String ... extensions) {
        for (String extension : extensions) {
            this.config.renderer(extension, renderer);
        }
        return this;
    }

    @Override
    public AppLifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public Jex.Server start() {
        if (this.config.health()) {
            this.plugin(new HealthPlugin());
        }
        SpiRoutes routes = ServiceLoader.load(SpiRoutesProvider.class).findFirst().get().create(this.routing, this.config.accessManager(), this.config.ignoreTrailingSlashes());
        SpiServiceManager serviceManager = ServiceLoader.load(SpiServiceManagerProvider.class).findFirst().get().create(this);
        Optional<SpiStartServer> start = ServiceLoader.load(SpiStartServer.class).findFirst();
        if (start.isEmpty()) {
            throw new IllegalStateException("There is no SpiStartServer? Missing dependency on jex-jetty?");
        }
        return start.get().start(this, routes, serviceManager);
    }
}

