/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.AppLifecycle;
import io.avaje.jex.Jex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultLifecycle
implements AppLifecycle {
    private static final Logger log = LoggerFactory.getLogger(Jex.class);
    private final List<Pair> shutdownRunnable = new ArrayList<Pair>();
    private final ReentrantLock lock = new ReentrantLock();
    private AppLifecycle.Status status = AppLifecycle.Status.STARTING;

    DefaultLifecycle() {
    }

    @Override
    public void onShutdown(Runnable onShutdown) {
        this.onShutdown(onShutdown, 1000);
    }

    @Override
    public void onShutdown(Runnable onShutdown, int order) {
        this.lock.lock();
        try {
            this.shutdownRunnable.add(new Pair(onShutdown, order));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void registerShutdownHook(Runnable onShutdown) {
        Hook hook = new Hook(onShutdown);
        Runtime.getRuntime().addShutdownHook(hook);
    }

    @Override
    public AppLifecycle.Status status() {
        return this.status;
    }

    @Override
    public void status(AppLifecycle.Status newStatus) {
        this.lock.lock();
        try {
            if (newStatus == AppLifecycle.Status.STOPPED) {
                this.fireOnShutdown();
            }
            this.status = newStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void fireOnShutdown() {
        Collections.sort(this.shutdownRunnable);
        for (Pair pair : this.shutdownRunnable) {
            try {
                pair.callback.run();
            }
            catch (Exception e) {
                log.error("Error running shutdown runnable", (Throwable)e);
                e.printStackTrace();
            }
        }
        log.info("Jex shutdown complete");
    }

    static class Pair
    implements Comparable<Pair> {
        private final Runnable callback;
        private final int order;

        Pair(Runnable callback, int order) {
            this.callback = callback;
            this.order = order;
        }

        @Override
        public int compareTo(Pair other) {
            return Integer.compare(this.order, other.order);
        }
    }

    static class Hook
    extends Thread {
        Hook(Runnable runnable) {
            super(runnable, "JexHook");
        }

        @Override
        public void run() {
            super.run();
        }
    }
}

