/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import java.util.List;
import java.util.stream.Collectors;

abstract class PathSegment {
    PathSegment() {
    }

    abstract String asRegexString(boolean var1);

    abstract void addParamName(List<String> var1);

    boolean multiSlash() {
        return false;
    }

    static class Wildcard
    extends PathSegment {
        Wildcard() {
        }

        @Override
        boolean multiSlash() {
            return true;
        }

        @Override
        public String asRegexString(boolean extract) {
            return extract ? "(.*?)" : ".*?";
        }

        @Override
        public void addParamName(List<String> paramNames) {
            paramNames.add(null);
        }
    }

    static class Literal
    extends PathSegment {
        private final String content;

        Literal(String content) {
            this.content = content;
        }

        @Override
        public String asRegexString(boolean extract) {
            return this.content;
        }

        @Override
        public void addParamName(List<String> paramNames) {
        }
    }

    static class Multi
    extends PathSegment {
        private final List<PathSegment> segments;

        Multi(List<PathSegment> segments) {
            this.segments = segments;
        }

        @Override
        boolean multiSlash() {
            for (PathSegment segment : this.segments) {
                if (!segment.multiSlash()) continue;
                return true;
            }
            return false;
        }

        @Override
        String asRegexString(boolean extract) {
            return this.segments.stream().map(pathSegment -> pathSegment.asRegexString(extract)).collect(Collectors.joining());
        }

        @Override
        void addParamName(List<String> paramNames) {
            for (PathSegment segment : this.segments) {
                segment.addParamName(paramNames);
            }
        }
    }

    private static abstract class Parameter
    extends PathSegment {
        private final String name;
        private final String regex;

        Parameter(String param, String acceptPattern) {
            String[] split = param.split(":", 2);
            this.name = split[0];
            this.regex = split.length == 1 ? acceptPattern : split[1];
        }

        @Override
        public String asRegexString(boolean extract) {
            return extract ? "(" + this.regex + ")" : this.regex;
        }

        @Override
        public void addParamName(List<String> paramNames) {
            paramNames.add(this.name);
        }
    }

    static class SlashAcceptingParameter
    extends Parameter {
        SlashAcceptingParameter(String param) {
            super(param, ".+?");
        }

        @Override
        boolean multiSlash() {
            return true;
        }
    }

    static class SlashIgnoringParameter
    extends Parameter {
        SlashIgnoringParameter(String param) {
            super(param, "[^/]+?");
        }
    }
}

