/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.inject.BeanScope;
import io.avaje.jex.AccessManager;
import io.avaje.jex.AppLifecycle;
import io.avaje.jex.DefaultErrorHandling;
import io.avaje.jex.DefaultLifecycle;
import io.avaje.jex.DefaultRouting;
import io.avaje.jex.DefaultStaticFileConfig;
import io.avaje.jex.ErrorHandling;
import io.avaje.jex.ExceptionHandler;
import io.avaje.jex.Plugin;
import io.avaje.jex.Routing;
import io.avaje.jex.ServerConfig;
import io.avaje.jex.StaticFileConfig;
import io.avaje.jex.TemplateRender;
import io.avaje.jex.UploadConfig;
import io.avaje.jex.core.HealthPlugin;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.SpiRoutes;
import io.avaje.jex.spi.SpiRoutesProvider;
import io.avaje.jex.spi.SpiServiceManager;
import io.avaje.jex.spi.SpiServiceManagerProvider;
import io.avaje.jex.spi.SpiStartServer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;

public class Jex {
    private final Routing routing = new DefaultRouting();
    private final ErrorHandling errorHandling = new DefaultErrorHandling();
    private final AppLifecycle lifecycle = new DefaultLifecycle();
    private final StaticFileConfig staticFiles;
    private final Map<Class<?>, Object> attributes = new HashMap();
    public final Config config = new Config();
    private ServerConfig serverConfig;

    private Jex() {
        this.staticFiles = new DefaultStaticFileConfig(this);
    }

    public static Jex create() {
        return new Jex();
    }

    public <T> Jex attribute(Class<T> cls, T instance) {
        this.attributes.put(cls, instance);
        return this;
    }

    public <T> T attribute(Class<T> cls) {
        return (T)this.attributes.get(cls);
    }

    public Jex errorHandling(ErrorHandling.Service service) {
        service.add(this.errorHandling);
        return this;
    }

    public ErrorHandling errorHandling() {
        return this.errorHandling;
    }

    public ServerConfig serverConfig() {
        return this.serverConfig;
    }

    public Jex serverConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        return this;
    }

    public Jex routing(Routing.Service routes) {
        this.routing.add(routes);
        return this;
    }

    public Jex routing(Collection<Routing.Service> routes) {
        this.routing.addAll(routes);
        return this;
    }

    public Routing routing() {
        return this.routing;
    }

    public Jex accessManager(AccessManager accessManager) {
        this.config.accessManager = accessManager;
        return this;
    }

    public Jex jsonService(JsonService jsonService) {
        this.config.jsonService = jsonService;
        return this;
    }

    public Jex plugin(Plugin plugin) {
        plugin.apply(this);
        return this;
    }

    public Jex configureWith(BeanScope beanScope) {
        this.lifecycle.onShutdown(() -> ((BeanScope)beanScope).close());
        AccessManager accessManager = (AccessManager)beanScope.get(AccessManager.class);
        if (accessManager != null) {
            this.accessManager(accessManager);
        }
        for (Plugin plugin : beanScope.list(Plugin.class)) {
            plugin.apply(this);
        }
        this.routing.addAll(beanScope.list(Routing.Service.class));
        return this;
    }

    public Jex configure(Consumer<Jex> configure) {
        configure.accept(this);
        return this;
    }

    public <T extends Exception> Jex exception(Class<T> exceptionClass, ExceptionHandler<T> handler) {
        this.errorHandling.exception(exceptionClass, handler);
        return this;
    }

    public Jex port(int port) {
        this.config.port = port;
        return this;
    }

    public Jex context(String contextPath) {
        this.config.contextPath = contextPath;
        return this;
    }

    public StaticFileConfig staticFiles() {
        return this.staticFiles;
    }

    public Jex register(TemplateRender renderer, String ... extensions) {
        for (String extension : extensions) {
            this.config.renderers.put(extension, renderer);
        }
        return this;
    }

    public Server start() {
        if (this.config.health) {
            this.plugin(new HealthPlugin());
        }
        SpiRoutes routes = ServiceLoader.load(SpiRoutesProvider.class).findFirst().get().create(this.routing, this.config.accessManager, this.config.ignoreTrailingSlashes);
        SpiServiceManager serviceManager = ServiceLoader.load(SpiServiceManagerProvider.class).findFirst().get().create(this);
        Optional<SpiStartServer> start = ServiceLoader.load(SpiStartServer.class).findFirst();
        if (start.isEmpty()) {
            throw new IllegalStateException("There is no SpiStartServer? Missing dependency on jex-jetty?");
        }
        return start.get().start(this, routes, serviceManager);
    }

    public AppLifecycle lifecycle() {
        return this.lifecycle;
    }

    public static class Config {
        public int port = 7001;
        public String host;
        public String contextPath = "/";
        public boolean health = true;
        public boolean prefer405 = true;
        public boolean ignoreTrailingSlashes = true;
        public boolean preCompressStaticFiles;
        public JsonService jsonService;
        public AccessManager accessManager;
        public UploadConfig multipartConfig;
        public int multipartFileThreshold = 8192;
        public final Map<String, TemplateRender> renderers = new HashMap<String, TemplateRender>();
    }

    public static interface Server {
        public void onShutdown(Runnable var1);

        public void shutdown();
    }
}

