/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jetty;

import io.avaje.jex.Context;
import io.avaje.jex.Jex;
import io.avaje.jex.Routing;
import io.avaje.jex.core.HttpMethodMap;
import io.avaje.jex.core.ServiceManager;
import io.avaje.jex.http.NotFoundResponse;
import io.avaje.jex.jetty.JexHttpContext;
import io.avaje.jex.jetty.StaticHandler;
import io.avaje.jex.spi.SpiContext;
import io.avaje.jex.spi.SpiRoutes;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

class JexHttpServlet
extends HttpServlet {
    private final SpiRoutes routes;
    private final ServiceManager manager;
    private final StaticHandler staticHandler;
    private final HttpMethodMap methodMap = new HttpMethodMap();
    private final boolean prefer405;

    JexHttpServlet(Jex jex, SpiRoutes routes, ServiceManager manager, StaticHandler staticHandler) {
        this.routes = routes;
        this.manager = manager;
        this.staticHandler = staticHandler;
        this.prefer405 = jex.inner.prefer405;
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) {
        String uri;
        Routing.Type routeType = this.method(req);
        SpiRoutes.Entry route = this.routes.match(routeType, uri = req.getRequestURI());
        if (route == null) {
            JexHttpContext ctx = new JexHttpContext(this.manager, req, res, uri);
            try {
                this.processNoRoute(ctx, uri, routeType);
                this.routes.after(uri, ctx);
            }
            catch (Exception e) {
                this.handleException(ctx, e);
            }
        } else {
            SpiRoutes.Params params = route.pathParams(uri);
            JexHttpContext ctx = new JexHttpContext(this.manager, req, res, route.matchPath(), params);
            try {
                this.processRoute(ctx, uri, route);
                this.routes.after(uri, ctx);
            }
            catch (Exception e) {
                this.handleException(ctx, e);
            }
        }
    }

    private void handleException(Context ctx, Exception e) {
        this.manager.handleException(ctx, e);
    }

    private void processRoute(SpiContext ctx, String uri, SpiRoutes.Entry route) {
        this.routes.before(uri, ctx);
        ctx.setMode(null);
        route.handle(ctx);
    }

    private void processNoRoute(SpiContext ctx, String uri, Routing.Type routeType) {
        this.routes.before(uri, ctx);
        if (routeType == Routing.Type.HEAD && this.hasGetHandler(uri)) {
            this.processHead(ctx);
            return;
        }
        if ((routeType == Routing.Type.GET || routeType == Routing.Type.HEAD) && this.staticHandler != null && this.staticHandler.handle(ctx.req(), ctx.res())) {
            return;
        }
        throw new NotFoundResponse("uri: " + uri);
    }

    private void processHead(Context ctx) {
        ctx.status(200);
    }

    private boolean hasGetHandler(String uri) {
        return this.routes.match(Routing.Type.GET, uri) != null;
    }

    private Routing.Type method(HttpServletRequest req) {
        return this.methodMap.get(req.getMethod());
    }
}

