/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.Context;
import io.avaje.jex.ErrorHandling;
import io.avaje.jex.ExceptionHandler;
import io.avaje.jex.http.HttpResponseException;
import io.avaje.jex.http.InternalServerErrorResponse;
import io.avaje.jex.http.RedirectResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionManager {
    private static final Logger log = LoggerFactory.getLogger(ExceptionManager.class);
    private final ErrorHandling errorHandling;

    public ExceptionManager(ErrorHandling errorHandling) {
        this.errorHandling = errorHandling;
    }

    public void handle(Context ctx, Exception e) {
        ExceptionHandler<Exception> handler = this.errorHandling.find(e.getClass());
        if (handler != null) {
            handler.handle(e, ctx);
        } else if (this.canHandle(e)) {
            this.defaultHandling(ctx, e);
        } else {
            this.unhandledException(ctx, e);
        }
    }

    private void unhandledException(Context ctx, Exception e) {
        log.warn("Uncaught exception", (Throwable)e);
        this.defaultHandling(ctx, new InternalServerErrorResponse());
    }

    private boolean canHandle(Exception e) {
        return HttpResponseException.class.isAssignableFrom(e.getClass());
    }

    private boolean isRedirect(Exception e) {
        return RedirectResponse.class.isAssignableFrom(e.getClass());
    }

    private void defaultHandling(Context ctx, Exception exception) {
        HttpResponseException e = this.unwrap(exception);
        ctx.status(e.getStatus());
        if (this.isRedirect(e)) {
            log.trace("redirect");
        } else if (this.useJson(ctx)) {
            ctx.contentType("application/json").write(this.asJsonContent(e));
        } else {
            ctx.text(this.asTextContent(e));
        }
    }

    private String asTextContent(HttpResponseException e) {
        return e.getMessage();
    }

    private String asJsonContent(HttpResponseException e) {
        return "{\"title\": " + this.jsonEscape(e.getMessage()) + ", \"status\": " + e.getStatus() + this.jsonDetails(e) + "}";
    }

    private String jsonEscape(String message) {
        return message;
    }

    private String jsonDetails(HttpResponseException e) {
        return "";
    }

    private HttpResponseException unwrap(Exception e) {
        return (HttpResponseException)e;
    }

    private boolean useJson(Context ctx) {
        String acceptHeader = ctx.header("Accept");
        return acceptHeader != null && acceptHeader.contains("application/json") || "application/json".equals(ctx.res().getContentType());
    }
}

