/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.UploadedFile;
import io.avaje.jex.core.PartUploadedFile;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class MultipartUtil {
    private final MultipartConfigElement config;

    MultipartUtil(MultipartConfigElement config) {
        this.config = config;
    }

    private void setConfig(HttpServletRequest req) {
        req.setAttribute("org.eclipse.jetty.multipartConfig", (Object)this.config);
    }

    List<UploadedFile> uploadedFiles(HttpServletRequest req, String partName) {
        try {
            this.setConfig(req);
            return req.getParts().stream().filter(part -> part.getName().equals(partName) && MultipartUtil.isFile(part)).map(this::toUploaded).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    UploadedFile toUploaded(Part part) {
        return new PartUploadedFile(part);
    }

    Map<String, List<String>> fieldMap(HttpServletRequest req) {
        this.setConfig(req);
        try {
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            for (Part part : req.getParts()) {
                if (!MultipartUtil.isField(part)) continue;
                String name = part.getName();
                String value = this.readAsString(part);
                map.computeIfAbsent(name, s -> new ArrayList()).add(value);
            }
            return map;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    private String readAsString(Part part) {
        try {
            return new BufferedReader(new InputStreamReader(part.getInputStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isFile(Part filePart) {
        return !MultipartUtil.isField(filePart);
    }

    private static boolean isField(Part filePart) {
        return filePart.getSubmittedFileName() == null;
    }
}

