/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.Context;
import io.avaje.jex.Handler;
import io.avaje.jex.Routing;
import io.avaje.jex.routes.PathParser;
import io.avaje.jex.spi.SpiRoutes;
import java.util.Map;

class FilterEntry
implements SpiRoutes.Entry {
    private final String path;
    private final boolean matchAll;
    private final PathParser pathParser;
    private final Handler handler;

    FilterEntry(Routing.Entry entry, boolean ignoreTrailingSlashes) {
        this.path = entry.getPath();
        this.matchAll = "/*".equals(this.path) || "*".equals(this.path);
        this.pathParser = this.matchAll ? null : new PathParser(this.path, ignoreTrailingSlashes);
        this.handler = entry.getHandler();
    }

    @Override
    public String matchPath() {
        return this.path;
    }

    @Override
    public boolean matches(String requestUri) {
        return this.matchAll || this.pathParser.matches(requestUri);
    }

    @Override
    public void handle(Context ctx) {
        this.handler.handle(ctx);
    }

    @Override
    public Map<String, String> pathParams(String uri) {
        throw new IllegalStateException("not allowed");
    }

    @Override
    public int getSegmentCount() {
        throw new IllegalStateException("not allowed");
    }
}

