/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jetty;

import io.avaje.jex.Jex;
import io.avaje.jex.StaticFileSource;
import io.avaje.jex.core.ServiceManager;
import io.avaje.jex.jetty.JettyNoopLogger;
import io.avaje.jex.jetty.JexHttpServlet;
import io.avaje.jex.jetty.StaticHandler;
import io.avaje.jex.jetty.StaticHandlerFactory;
import io.avaje.jex.routes.RoutesBuilder;
import io.avaje.jex.spi.SpiRoutes;
import java.io.IOException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyLaunch
implements Jex.Server {
    private static final Logger log = LoggerFactory.getLogger(JettyLaunch.class);
    private final Jex jex;
    private final SpiRoutes routes;
    private final org.eclipse.jetty.util.log.Logger defaultLogger;
    private Server server;

    public JettyLaunch(Jex jex) {
        this.jex = jex;
        this.defaultLogger = Log.getLog();
        this.routes = new RoutesBuilder(jex.routing(), jex).build();
    }

    @Override
    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Jex.Server start() {
        try {
            this.disableJettyLog();
            this.server = this.createServer();
            this.server.start();
            this.logOnStart(this.server);
            this.enableJettyLog();
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting server", e);
        }
    }

    protected Server createServer() {
        Server server = this.initServer();
        server.setHandler((Handler)this.initContextHandler());
        server.setStopAtShutdown(true);
        return server;
    }

    private Server initServer() {
        Server server = this.jex.jetty.server;
        return server != null ? server : new Server(this.jex.inner.port);
    }

    protected ServletContextHandler initContextHandler() {
        ServletContextHandler sc = this.initServletContextHandler();
        sc.setSessionHandler(this.initSessionHandler());
        sc.addServlet(this.initServletHolder(), "/*");
        return sc;
    }

    protected ServletHolder initServletHolder() {
        ServiceManager manager = this.serviceManager();
        StaticHandler staticHandler = this.initStaticHandler();
        return new ServletHolder((Servlet)new JexHttpServlet(this.jex, this.routes, manager, staticHandler));
    }

    protected ServletContextHandler initServletContextHandler() {
        ServletContextHandler ch = this.jex.jetty.contextHandler;
        return ch != null ? ch : new ContextHandler(this.jex.inner.contextPath, this.jex.jetty.sessions, this.jex.jetty.security);
    }

    protected SessionHandler initSessionHandler() {
        SessionHandler sh = this.jex.jetty.sessionHandler;
        return sh == null ? this.defaultSessionHandler() : sh;
    }

    protected SessionHandler defaultSessionHandler() {
        SessionHandler sh = new SessionHandler();
        sh.setHttpOnly(true);
        return sh;
    }

    protected StaticHandler initStaticHandler() {
        List<StaticFileSource> fileSources = this.jex.staticFiles().getSources();
        if (fileSources == null || fileSources.isEmpty()) {
            return null;
        }
        StaticHandlerFactory factory = new StaticHandlerFactory();
        return factory.build(this.jex, fileSources);
    }

    protected ServiceManager serviceManager() {
        return ServiceManager.create(this.jex);
    }

    private void logOnStart(Server server) {
        for (Connector c : server.getConnectors()) {
            if (c instanceof ServerConnector) {
                ServerConnector sc = (ServerConnector)c;
                String host = sc.getHost() == null ? "localhost" : sc.getHost();
                log.info("Listening with {} host:{} port:{}", new Object[]{sc.getProtocols(), host, sc.getLocalPort()});
                continue;
            }
            log.info("bind to {}", (Object)c);
        }
    }

    private void enableJettyLog() {
        Log.setLog((org.eclipse.jetty.util.log.Logger)this.defaultLogger);
    }

    private void disableJettyLog() {
        Log.setLog((org.eclipse.jetty.util.log.Logger)new JettyNoopLogger());
    }

    private static class ContextHandler
    extends ServletContextHandler {
        ContextHandler(String contextPath, boolean sessions, boolean security) {
            super(null, contextPath, sessions, security);
        }

        public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            request.setAttribute("jetty-target", (Object)target);
            request.setAttribute("jetty-request", (Object)baseRequest);
            this.nextHandle(target, baseRequest, request, response);
        }
    }
}

