/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.jetty;

import io.avaje.jex.jetty.JexHttpContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

class ContextUtil {
    public static final String UTF_8 = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int BUFFER_MAX = 65536;

    ContextUtil() {
    }

    static String getRequestCharset(JexHttpContext ctx) {
        String header = ctx.req.getHeader("Content-Type");
        if (header != null) {
            return ContextUtil.parseCharset(header);
        }
        return UTF_8;
    }

    static String parseCharset(String header) {
        for (String val : header.split(";")) {
            if (!(val = val.trim()).regionMatches(true, 0, "charset", 0, "charset".length())) continue;
            return val.split("=")[1].trim();
        }
        return UTF_8;
    }

    static byte[] readBody(HttpServletRequest req) {
        try {
            ServletInputStream inputStream = req.getInputStream();
            int bufferSize = inputStream.available();
            if (bufferSize < 8192) {
                bufferSize = 8192;
            } else if (bufferSize > 65536) {
                bufferSize = 65536;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream(bufferSize);
            ContextUtil.copy((InputStream)inputStream, os, bufferSize);
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        while ((len = in.read(buffer, 0, bufferSize)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    static Map<String, List<String>> formParamMap(String body, String charset) {
        if (body.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            for (String pair : body.split("&")) {
                String[] split1 = pair.split("=", 2);
                String key = URLDecoder.decode(split1[0], charset);
                String val = split1.length > 1 ? URLDecoder.decode(split1[1], charset) : "";
                map.computeIfAbsent(key, s -> new ArrayList()).add(val);
            }
            return map;
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }
}

