/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.grizzly.spi;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import io.avaje.jex.grizzly.spi.GrizzlyHandler;
import io.avaje.jex.grizzly.spi.GrizzlyHttpContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;

final class GrizzlyHttpServer
extends HttpsServer {
    private static final System.Logger LOG = System.getLogger(GrizzlyHttpServer.class.getCanonicalName());
    private final HttpServer server;
    private InetSocketAddress addr;
    private ServerConfiguration httpConfiguration;
    private ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
    private HttpsConfigurator httpsConfig;

    public GrizzlyHttpServer(HttpServer server) {
        this(server, server.getServerConfiguration());
    }

    public GrizzlyHttpServer(HttpServer server, ServerConfiguration configuration) {
        this.server = server;
        this.httpConfiguration = configuration;
    }

    public ServerConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    @Override
    public void bind(InetSocketAddress addr, int backlog) throws IOException {
        this.addr = addr;
        Collection connectors = this.server.getListeners();
        if (connectors != null) {
            for (NetworkListener connector : connectors) {
                if (connector.getPort() != addr.getPort()) continue;
                LOG.log(System.Logger.Level.DEBUG, "server already bound to port {}, no need to rebind", addr.getPort());
                return;
            }
        }
        if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
            LOG.log(System.Logger.Level.DEBUG, "binding server to port " + addr.getPort());
        }
        NetworkListener listener = new NetworkListener("rizzly", addr.getHostName(), addr.getPort());
        listener.getTransport().setWorkerThreadPool(this.executor);
        if (backlog != 0) {
            listener.getTransport().setServerConnectionBackLog(backlog);
        }
        if (this.httpsConfig != null) {
            listener.setSSLEngineConfig(new SSLEngineConfigurator(this.httpsConfig.getSSLContext()));
        }
        this.server.addListener(listener);
    }

    protected HttpServer getServer() {
        return this.server;
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.addr.getPort() == 0 && this.server.isStarted()) {
            return new InetSocketAddress(this.addr.getHostString(), this.server.getListener("rizzly").getPort());
        }
        return this.addr;
    }

    @Override
    public void start() {
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setExecutor(Executor executor) {
        ExecutorService service;
        if (!(executor instanceof ExecutorService)) {
            throw new IllegalArgumentException("Grizzly only accepts an instance of ExecutorService");
        }
        this.executor = service = (ExecutorService)executor;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void stop(int delay) {
        this.server.shutdownNow();
    }

    @Override
    public HttpContext createContext(String path, com.sun.net.httpserver.HttpHandler httpHandler) {
        GrizzlyHttpContext context = new GrizzlyHttpContext(this, path, httpHandler);
        GrizzlyHandler jettyContextHandler = context.getGrizzlyHandler();
        this.httpConfiguration.addHttpHandler((HttpHandler)jettyContextHandler, new String[]{path.transform(this::prependSlash).transform(this::appendSlash)});
        return context;
    }

    private String prependSlash(String s) {
        return s.startsWith("/") ? s : "/" + s;
    }

    private String appendSlash(String s) {
        return s.endsWith("/") ? s + "*" : s + "/*";
    }

    @Override
    public HttpContext createContext(String path) {
        return this.createContext(path, null);
    }

    @Override
    public void removeContext(String path) {
        throw new UnsupportedOperationException("notImplemented");
    }

    @Override
    public void removeContext(HttpContext context) {
        throw new UnsupportedOperationException("notImplemented");
    }

    @Override
    public void setHttpsConfigurator(HttpsConfigurator config) {
        this.httpsConfig = config;
    }

    @Override
    public HttpsConfigurator getHttpsConfigurator() {
        return this.httpsConfig;
    }
}

