/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.grizzly.spi;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;

final class GrizzlyHttpExchangeDelegate
extends HttpExchange {
    private static final Set<String> SINGLE_VALUE_HEADERS = Set.of("authorization", "content-length", "date", "expires", "host", "if-modified-since", "if-unmodified-since", "if-range", "last-modified", "location", "referer", "retry-after", "user-agent");
    private final HttpContext context;
    private final Request request;
    private final Headers responseHeaders = new Headers();
    private Headers requestHeaders = new Headers();
    private int statusCode = 0;
    private InputStream inputStream;
    private OutputStream outputStream;
    private HttpPrincipal httpPrincipal;
    private Response response;

    GrizzlyHttpExchangeDelegate(HttpContext httpSpiContext, Request request, Response response) {
        this.context = httpSpiContext;
        this.request = request;
        this.response = response;
        this.inputStream = request.getInputStream();
        this.outputStream = response.getOutputStream();
    }

    @Override
    public Headers getRequestHeaders() {
        if (!this.requestHeaders.isEmpty()) {
            return this.requestHeaders;
        }
        for (String name : this.request.getHeaderNames()) {
            if (!SINGLE_VALUE_HEADERS.contains(name.toLowerCase())) {
                for (String value : this.request.getHeaders(name)) {
                    this.requestHeaders.add(name, value);
                }
                continue;
            }
            this.requestHeaders.add(name, this.request.getHeader(name));
        }
        return this.requestHeaders;
    }

    @Override
    public Headers getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public URI getRequestURI() {
        return URI.create(this.request.getRequestURI());
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod().getMethodString();
    }

    @Override
    public HttpContext getHttpContext() {
        return this.context;
    }

    @Override
    public void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public InputStream getRequestBody() {
        return this.inputStream;
    }

    @Override
    public OutputStream getResponseBody() {
        return this.outputStream;
    }

    @Override
    public void sendResponseHeaders(int rCode, long responseLength) throws IOException {
        this.statusCode = rCode;
        for (Map.Entry<String, List<String>> stringListEntry : this.responseHeaders.entrySet()) {
            String name = stringListEntry.getKey();
            List<String> values = stringListEntry.getValue();
            for (String value : values) {
                this.response.addHeader(name, value);
            }
        }
        if (responseLength == -1L) {
            this.response.setContentLengthLong(0L);
        } else if (responseLength == 0L) {
            this.response.setContentLengthLong(-1L);
        } else {
            this.response.setContentLengthLong(responseLength);
        }
        this.response.setStatus(rCode);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return InetSocketAddress.createUnresolved(this.request.getRemoteAddr(), this.request.getRemotePort());
    }

    @Override
    public int getResponseCode() {
        return this.statusCode;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.request.getLocalAddr(), this.request.getLocalPort());
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol().getProtocolString();
    }

    @Override
    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public void setStreams(InputStream i, OutputStream o) {
        assert (this.inputStream != null);
        if (i != null) {
            this.inputStream = i;
        }
        if (o != null) {
            this.outputStream = o;
        }
    }

    @Override
    public HttpPrincipal getPrincipal() {
        return this.httpPrincipal;
    }

    public void setPrincipal(HttpPrincipal principal) {
        this.httpPrincipal = principal;
    }
}

