/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScope;
import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.test.MetaReader;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class InjectExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace INJECT_NS = ExtensionContext.Namespace.create((Object[])new Object[]{"io.avaje.inject"});
    private static final String BEAN_SCOPE = "BEAN_SCOPE";

    public void beforeEach(ExtensionContext context) {
        List<MetaReader> readers = this.createMetaReaders(context);
        BeanScopeBuilder builder = BeanScope.newBuilder();
        for (MetaReader reader : readers) {
            reader.build(builder);
        }
        BeanScope beanScope = builder.build();
        for (MetaReader reader : readers) {
            reader.setFromScope(beanScope);
        }
        context.getStore(INJECT_NS).put((Object)BEAN_SCOPE, (Object)beanScope);
    }

    private List<MetaReader> createMetaReaders(ExtensionContext context) {
        List testInstances = context.getRequiredTestInstances().getAllInstances();
        ArrayList<MetaReader> readers = new ArrayList<MetaReader>(testInstances.size());
        for (Object testInstance : testInstances) {
            readers.add(new MetaReader(testInstance));
        }
        return readers;
    }

    public void afterEach(ExtensionContext context) {
        BeanScope beanScope = (BeanScope)context.getStore(INJECT_NS).remove((Object)BEAN_SCOPE);
        if (beanScope != null) {
            beanScope.close();
        }
    }
}

