/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.openapi.KnownTypes;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

class SchemaDocBuilder {
    private static final String APP_FORM = "application/x-www-form-urlencoded";
    private static final String APP_JSON = "application/json";
    private final Types types;
    private final KnownTypes knownTypes;
    private final TypeMirror iterableType;
    private final TypeMirror mapType;
    private final Map<String, Schema> schemas = new TreeMap<String, Schema>();

    SchemaDocBuilder(Types types, Elements elements) {
        this.types = types;
        this.knownTypes = new KnownTypes();
        this.iterableType = types.erasure(elements.getTypeElement("java.lang.Iterable").asType());
        this.mapType = types.erasure(elements.getTypeElement("java.util.Map").asType());
    }

    Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    Content createContent(TypeMirror returnType, String mediaType) {
        MediaType mt = new MediaType();
        mt.setSchema(this.toSchema(returnType));
        Content content = new Content();
        content.addMediaType(mediaType, mt);
        return content;
    }

    void addFormParam(Operation operation, String varName, Schema schema) {
        RequestBody body = this.requestBody(operation);
        Schema formSchema = this.requestFormParamSchema(body);
        formSchema.addProperties(varName, schema);
    }

    private Schema requestFormParamSchema(RequestBody body) {
        Schema schema;
        Content content = body.getContent();
        MediaType mediaType = (MediaType)content.get((Object)APP_FORM);
        if (mediaType != null) {
            schema = mediaType.getSchema();
        } else {
            schema = new Schema();
            schema.setType("object");
            mediaType = new MediaType();
            mediaType.schema(schema);
            content.addMediaType(APP_FORM, mediaType);
        }
        return schema;
    }

    void addRequestBody(Operation operation, Schema schema, boolean asForm, String description) {
        RequestBody body = this.requestBody(operation);
        body.setDescription(description);
        MediaType mt = new MediaType();
        mt.schema(schema);
        String mime = asForm ? APP_FORM : APP_JSON;
        body.getContent().addMediaType(mime, mt);
    }

    private RequestBody requestBody(Operation operation) {
        RequestBody body = operation.getRequestBody();
        if (body == null) {
            body = new RequestBody();
            body.setRequired(Boolean.valueOf(true));
            Content content = new Content();
            body.setContent(content);
            operation.setRequestBody(body);
        }
        return body;
    }

    Schema<?> toSchema(TypeMirror type) {
        Schema<?> schema = this.knownTypes.createSchema(Util.typeDef(type));
        if (schema != null) {
            return schema;
        }
        if (this.types.isAssignable(type, this.mapType)) {
            return this.buildMapSchema(type);
        }
        if (type.getKind() == TypeKind.ARRAY) {
            return this.buildArraySchema(type);
        }
        if (this.types.isAssignable(type, this.iterableType)) {
            return this.buildIterableSchema(type);
        }
        return this.buildObjectSchema(type);
    }

    private Schema<?> buildObjectSchema(TypeMirror type) {
        String objectSchemaKey = this.getObjectSchemaName(type);
        Schema objectSchema = this.schemas.get(objectSchemaKey);
        if (objectSchema == null) {
            objectSchema = new ObjectSchema();
            this.schemas.put(objectSchemaKey, objectSchema);
            this.populateObjectSchema(type, objectSchema);
        }
        Schema ref = new Schema();
        ref.$ref("#/components/schemas/" + objectSchemaKey);
        return ref;
    }

    private Schema<?> buildIterableSchema(TypeMirror type) {
        List<? extends TypeMirror> typeArguments;
        Schema<?> itemSchema = new ObjectSchema().format("unknownIterableType");
        if (type.getKind() == TypeKind.DECLARED && (typeArguments = ((DeclaredType)type).getTypeArguments()).size() == 1) {
            itemSchema = this.toSchema(typeArguments.get(0));
        }
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setItems((Schema)itemSchema);
        return arraySchema;
    }

    private Schema<?> buildArraySchema(TypeMirror type) {
        ArrayType arrayType = this.types.getArrayType(type);
        Schema<?> itemSchema = this.toSchema(arrayType.getComponentType());
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setItems(itemSchema);
        return arraySchema;
    }

    private Schema<?> buildMapSchema(TypeMirror type) {
        DeclaredType declaredType;
        List<? extends TypeMirror> typeArguments;
        Schema<?> valueSchema = new ObjectSchema().format("unknownMapValueType");
        if (type.getKind() == TypeKind.DECLARED && (typeArguments = (declaredType = (DeclaredType)type).getTypeArguments()).size() == 2) {
            valueSchema = this.toSchema(typeArguments.get(1));
        }
        MapSchema mapSchema = new MapSchema();
        mapSchema.setAdditionalProperties((Object)valueSchema);
        return mapSchema;
    }

    private String getObjectSchemaName(TypeMirror type) {
        String canonicalName = type.toString();
        int pos = canonicalName.lastIndexOf(46);
        if (pos > -1) {
            canonicalName = canonicalName.substring(pos + 1);
        }
        return canonicalName;
    }

    private <T> void populateObjectSchema(TypeMirror objectType, Schema<T> objectSchema) {
        Element element = this.types.asElement(objectType);
        for (VariableElement field : this.allFields(element)) {
            Schema<?> propSchema = this.toSchema(field.asType());
            if (this.isNotNullable(field)) {
                propSchema.setNullable(Boolean.FALSE);
            }
            this.setLengthMinMax(field, propSchema);
            this.setFormatFromValidation(field, propSchema);
            objectSchema.addProperties(field.getSimpleName().toString(), propSchema);
        }
    }

    private void setFormatFromValidation(Element element, Schema<?> propSchema) {
        if (element.getAnnotation(Email.class) != null) {
            propSchema.setFormat("email");
        }
    }

    private void setLengthMinMax(Element element, Schema<?> propSchema) {
        Size size = element.getAnnotation(Size.class);
        if (size != null) {
            if (size.min() > 0) {
                propSchema.setMinLength(Integer.valueOf(size.min()));
            }
            if (size.max() > 0) {
                propSchema.setMaxLength(Integer.valueOf(size.max()));
            }
        }
    }

    private boolean isNotNullable(Element element) {
        return element.getAnnotation(org.jetbrains.annotations.NotNull.class) != null || element.getAnnotation(NotNull.class) != null;
    }

    private List<VariableElement> allFields(Element element) {
        ArrayList<VariableElement> list = new ArrayList<VariableElement>();
        this.gatherProperties(list, element);
        return list;
    }

    private void gatherProperties(List<VariableElement> fields, Element element) {
        if (element == null) {
            return;
        }
        if (element instanceof TypeElement) {
            Element mappedSuper = this.types.asElement(((TypeElement)element).getSuperclass());
            if (mappedSuper != null && !"java.lang.Object".equals(mappedSuper.toString())) {
                this.gatherProperties(fields, mappedSuper);
            }
            for (VariableElement field : ElementFilter.fieldsIn(element.getEnclosedElements())) {
                if (this.ignoreField(field)) continue;
                fields.add(field);
            }
        }
    }

    private boolean ignoreField(VariableElement field) {
        return this.isStaticOrTransient(field) || this.isHiddenField(field);
    }

    private boolean isHiddenField(VariableElement field) {
        Hidden hidden = field.getAnnotation(Hidden.class);
        if (hidden != null) {
            return true;
        }
        for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
            String simpleName = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
            if (!"JsonIgnore".equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    private boolean isStaticOrTransient(VariableElement field) {
        Set<Modifier> modifiers = field.getModifiers();
        return modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT);
    }
}

