/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import io.avaje.http.generator.core.ElementReader;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.javadoc.Javadoc;
import io.avaje.http.generator.core.openapi.DocContext;
import io.avaje.http.generator.core.openapi.MethodDocBuilder;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import javax.lang.model.element.Element;

public class MethodParamDocBuilder {
    private final DocContext ctx;
    private final Javadoc javadoc;
    private final Operation operation;
    private final String paramName;
    private final String varName;
    private final String rawType;
    private final ParamType paramType;
    private final Element element;

    public MethodParamDocBuilder(MethodDocBuilder methodDoc, ElementReader param) {
        this.ctx = methodDoc.getContext();
        this.javadoc = methodDoc.getJavadoc();
        this.operation = methodDoc.getOperation();
        this.paramType = param.getParamType();
        this.paramName = param.getParamName();
        this.varName = param.getVarName();
        this.rawType = param.getRawType();
        this.element = param.getElement();
    }

    public void build() {
        if (this.paramType == ParamType.FORM || this.paramType == ParamType.BODY) {
            this.addMetaRequestBody(this.ctx, this.javadoc, this.operation);
        } else {
            Parameter param = new Parameter();
            param.setName(this.varName);
            param.setDescription(this.javadoc.getParams().get(this.paramName));
            Schema schema = this.ctx.toSchema(this.rawType, this.element);
            if (this.paramType == ParamType.FORMPARAM) {
                this.ctx.addFormParam(this.operation, this.varName, schema);
            } else {
                param.setSchema(schema);
                param.setIn(this.paramType.getType());
                this.operation.addParametersItem(param);
            }
        }
    }

    private void addMetaRequestBody(DocContext ctx, Javadoc javadoc, Operation operation) {
        Schema schema = ctx.toSchema(this.rawType, this.element);
        String description = javadoc.getParams().get(this.paramName);
        boolean asForm = this.paramType == ParamType.FORM;
        ctx.addRequestBody(operation, schema, asForm, description);
    }
}

