/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import io.avaje.http.generator.core.MethodParam;
import io.avaje.http.generator.core.MethodReader;
import io.avaje.http.generator.core.javadoc.Javadoc;
import io.avaje.http.generator.core.openapi.DocContext;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;

public class MethodDocBuilder {
    private final Javadoc javadoc;
    private final MethodReader methodReader;
    private final DocContext ctx;
    private final Operation operation = new Operation();

    public MethodDocBuilder(MethodReader methodReader, DocContext ctx) {
        this.methodReader = methodReader;
        this.ctx = ctx;
        this.javadoc = methodReader.getJavadoc();
    }

    public void build() {
        if (this.ctx.isOpenApiAvailable() && this.methodReader.findAnnotation(Hidden.class) != null) {
            return;
        }
        this.operation.setSummary(this.javadoc.getSummary());
        this.operation.setDescription(this.javadoc.getDescription());
        this.operation.setTags(this.methodReader.getTags());
        if (this.javadoc.isDeprecated()) {
            this.operation.setDeprecated(Boolean.valueOf(true));
        } else if (this.methodReader.findAnnotation(Deprecated.class) != null) {
            this.operation.setDeprecated(Boolean.valueOf(true));
        }
        PathItem pathItem = this.ctx.pathItem(this.methodReader.getFullPath());
        switch (this.methodReader.getWebMethod()) {
            case GET: {
                pathItem.setGet(this.operation);
                break;
            }
            case PUT: {
                pathItem.setPut(this.operation);
                break;
            }
            case POST: {
                pathItem.setPost(this.operation);
                break;
            }
            case DELETE: {
                pathItem.setDelete(this.operation);
                break;
            }
            case PATCH: {
                pathItem.setPatch(this.operation);
            }
        }
        for (MethodParam param : this.methodReader.getParams()) {
            param.buildApiDocumentation(this);
        }
        ApiResponses responses = new ApiResponses();
        this.operation.setResponses(responses);
        ApiResponse response = new ApiResponse();
        response.setDescription(this.javadoc.getReturnDescription());
        if (this.methodReader.isVoid()) {
            if (this.isEmpty(response.getDescription())) {
                response.setDescription("No content");
            }
        } else {
            String produces = this.methodReader.getProduces();
            String contentMediaType = produces == null ? "application/json" : produces;
            response.setContent(this.ctx.createContent(this.methodReader.getReturnType(), contentMediaType));
        }
        responses.addApiResponse(this.methodReader.getStatusCode(), response);
    }

    DocContext getContext() {
        return this.ctx;
    }

    Javadoc getJavadoc() {
        return this.javadoc;
    }

    Operation getOperation() {
        return this.operation;
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

