/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

class KnownTypes {
    private final Map<String, KnownType> typeMap = new HashMap<String, KnownType>();

    KnownTypes() {
        this.add(new StringType(), String.class, char[].class, CharSequence.class);
        this.add(new BoolType(), Boolean.TYPE);
        this.add(new BooleanType(), Boolean.class);
        this.add(new IntType(), Integer.TYPE);
        this.add(new IntegerType(), Integer.class);
        this.add(new PLongType(), Long.TYPE);
        this.add(new LongType(), Long.class);
        this.add(new PNumberType(), Double.TYPE, Float.TYPE);
        this.add(new NumberType(), Double.class, Float.class, BigDecimal.class, BigInteger.class);
        this.add(new DateType(), LocalDate.class, Date.class);
        this.add(new DateTimeType(), Instant.class, OffsetDateTime.class, ZonedDateTime.class, Timestamp.class, java.util.Date.class, LocalDateTime.class);
        this.add(new UUIDType(), UUID.class);
        this.add(new URLType(), URL.class);
        this.add(new URIType(), URI.class);
        this.add(new FileType(), File.class);
    }

    Schema<?> createSchema(String type) {
        KnownType knownType = this.typeMap.get(type);
        return knownType != null ? knownType.createSchema() : null;
    }

    private void add(KnownType type, Class<?> ... keys) {
        for (Class<?> key : keys) {
            this.typeMap.put(key.getCanonicalName(), type);
        }
    }

    private class StringBaseType
    implements KnownType {
        private final String format;

        private StringBaseType(String format) {
            this.format = format;
        }

        @Override
        public Schema<?> createSchema() {
            return new StringSchema().format(this.format);
        }
    }

    private class URIType
    extends StringBaseType {
        private URIType() {
            super("uri");
        }
    }

    private class URLType
    extends StringBaseType {
        private URLType() {
            super("url");
        }
    }

    private class UUIDType
    extends StringBaseType {
        private UUIDType() {
            super("uuid");
        }
    }

    private class DateTimeType
    implements KnownType {
        private DateTimeType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new DateTimeSchema();
        }
    }

    private class DateType
    implements KnownType {
        private DateType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new DateSchema();
        }
    }

    private class NumberType
    implements KnownType {
        private NumberType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new NumberSchema();
        }
    }

    private class PNumberType
    implements KnownType {
        private PNumberType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new NumberSchema().nullable(Boolean.FALSE);
        }
    }

    private class LongType
    implements KnownType {
        private LongType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new IntegerSchema().format("int64");
        }
    }

    private class PLongType
    implements KnownType {
        private PLongType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new IntegerSchema().format("int64").nullable(Boolean.FALSE);
        }
    }

    private class IntegerType
    implements KnownType {
        private IntegerType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new IntegerSchema();
        }
    }

    private class IntType
    implements KnownType {
        private IntType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new IntegerSchema().nullable(Boolean.FALSE);
        }
    }

    private class BooleanType
    implements KnownType {
        private BooleanType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new BooleanSchema();
        }
    }

    private class BoolType
    implements KnownType {
        private BoolType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new BooleanSchema().nullable(Boolean.FALSE);
        }
    }

    private class StringType
    implements KnownType {
        private StringType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new StringSchema();
        }
    }

    private class FileType
    implements KnownType {
        private FileType() {
        }

        @Override
        public Schema<?> createSchema() {
            return new FileSchema();
        }
    }

    static interface KnownType {
        public Schema<?> createSchema();
    }
}

