/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.avaje.http.generator.core.openapi.SchemaDocBuilder;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class DocContext {
    private final boolean openApiAvailable;
    private final Elements elements;
    private final Filer filer;
    private final Messager messager;
    private final Map<String, PathItem> pathMap = new TreeMap<String, PathItem>();
    private final SchemaDocBuilder schemaBuilder;
    private final OpenAPI openAPI;

    public DocContext(ProcessingEnvironment env, boolean openApiAvailable) {
        this.openApiAvailable = openApiAvailable;
        this.elements = env.getElementUtils();
        this.filer = env.getFiler();
        this.messager = env.getMessager();
        this.schemaBuilder = new SchemaDocBuilder(env.getTypeUtils(), env.getElementUtils());
        this.openAPI = this.initOpenAPI();
    }

    public boolean isOpenApiAvailable() {
        return this.openApiAvailable;
    }

    private OpenAPI initOpenAPI() {
        OpenAPI openAPI = new OpenAPI();
        openAPI.setPaths(new Paths());
        io.swagger.v3.oas.models.info.Info info = new io.swagger.v3.oas.models.info.Info();
        info.setTitle("");
        info.setVersion("");
        openAPI.setInfo(info);
        return openAPI;
    }

    Schema toSchema(String rawType, Element element) {
        TypeElement typeElement = this.elements.getTypeElement(rawType);
        if (typeElement == null) {
            return this.schemaBuilder.toSchema(element.asType());
        }
        return this.schemaBuilder.toSchema(typeElement.asType());
    }

    Content createContent(TypeMirror returnType, String mediaType) {
        return this.schemaBuilder.createContent(returnType, mediaType);
    }

    PathItem pathItem(String fullPath) {
        return this.pathMap.computeIfAbsent(fullPath, s -> new PathItem());
    }

    void addFormParam(Operation operation, String varName, Schema schema) {
        this.schemaBuilder.addFormParam(operation, varName, schema);
    }

    void addRequestBody(Operation operation, Schema schema, boolean asForm, String description) {
        this.schemaBuilder.addRequestBody(operation, schema, asForm, description);
    }

    private OpenAPI getApiForWriting() {
        Paths paths = this.openAPI.getPaths();
        if (paths == null) {
            paths = new Paths();
            this.openAPI.setPaths(paths);
        }
        for (Map.Entry<String, PathItem> entry : this.pathMap.entrySet()) {
            paths.addPathItem(entry.getKey(), entry.getValue());
        }
        this.components().setSchemas(this.schemaBuilder.getSchemas());
        return this.openAPI;
    }

    private Components components() {
        Components components = this.openAPI.getComponents();
        if (components == null) {
            components = new Components();
            this.openAPI.setComponents(components);
        }
        return components;
    }

    private io.swagger.v3.oas.models.tags.Tag createTagItem(Tag tag) {
        io.swagger.v3.oas.models.tags.Tag tagsItem = new io.swagger.v3.oas.models.tags.Tag();
        tagsItem.setName(tag.name());
        tagsItem.setDescription(tag.description());
        return tagsItem;
    }

    public void addTagsDefinition(Element element) {
        Tags tags = element.getAnnotation(Tags.class);
        if (tags == null) {
            return;
        }
        for (Tag tag : tags.value()) {
            this.openAPI.addTagsItem(this.createTagItem(tag));
        }
    }

    public void addTagDefinition(Element element) {
        Tag tag = element.getAnnotation(Tag.class);
        if (tag == null) {
            return;
        }
        this.openAPI.addTagsItem(this.createTagItem(tag));
    }

    public void readApiDefinition(Element element) {
        OpenAPIDefinition openApi = element.getAnnotation(OpenAPIDefinition.class);
        Info info = openApi.info();
        if (!info.title().isEmpty()) {
            this.openAPI.getInfo().setTitle(info.title());
        }
        if (!info.description().isEmpty()) {
            this.openAPI.getInfo().setDescription(info.description());
        }
        if (!info.version().isEmpty()) {
            this.openAPI.getInfo().setVersion(info.version());
        }
    }

    public void writeApi() {
        try (Writer metaWriter = this.createMetaWriter();){
            OpenAPI openAPI = this.getApiForWriting();
            ObjectMapper mapper = this.createObjectMapper();
            mapper.writeValue(metaWriter, (Object)openAPI);
        }
        catch (IOException e) {
            this.logError(null, "Error writing openapi file" + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    private Writer createMetaWriter() throws IOException {
        FileObject writer = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "meta", "openapi.json", null);
        return writer.openWriter();
    }

    private void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }
}

