/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class Util {
    public static String typeDef(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return declaredType.asElement().toString();
        }
        return typeMirror.toString();
    }

    static String trimPath(String value) {
        return value.length() <= 1 ? value : Util.trimTrailingSlash(value);
    }

    private static String trimTrailingSlash(String value) {
        if (value.endsWith("/")) {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    static String combinePath(String beanPath, String webMethodPath) {
        StringBuilder sb = new StringBuilder();
        if (beanPath != null) {
            sb.append(beanPath);
        }
        if (webMethodPath != null) {
            if (!webMethodPath.isEmpty() && !webMethodPath.startsWith("/")) {
                sb.append("/");
            }
            sb.append(Util.trimTrailingSlash(webMethodPath));
        }
        return sb.toString();
    }

    public static String shortName(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        return fullType.substring(p + 1);
    }

    public static String snakeCase(String name) {
        StringBuilder sb = new StringBuilder(name.length() + 5);
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append("-");
                }
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String initcapSnake(String input) {
        StringBuilder sb = new StringBuilder(input.length());
        int len = input.length();
        boolean upper = true;
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '-') {
                sb.append(ch);
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(Character.toUpperCase(ch));
                upper = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static List<String> findRoles(Element element) {
        ArrayList<String> roles = new ArrayList<String>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!Util.isRolesAnnotation(annotationType)) continue;
            for (AnnotationValue annotationValue : annotationMirror.getElementValues().values()) {
                String raw = annotationValue.toString();
                if (raw.startsWith("{")) {
                    raw = raw.substring(1, raw.length() - 1);
                }
                for (String singleRole : raw.split(",")) {
                    roles.add(singleRole.trim());
                }
            }
        }
        return roles;
    }

    private static boolean isRolesAnnotation(DeclaredType annotationType) {
        String name = annotationType.asElement().getSimpleName().toString();
        return name.endsWith("Roles") || name.endsWith("PermittedRoles");
    }

    public static String propertyName(String setterMethod) {
        String prop = setterMethod.substring(3);
        return Character.toLowerCase(prop.charAt(0)) + prop.substring(1);
    }
}

