/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.TypeHandler;
import java.util.HashMap;
import java.util.Map;

class TypeMap {
    private static final Map<String, TypeHandler> types = new HashMap<String, TypeHandler>();

    TypeMap() {
    }

    private static void add(TypeHandler h) {
        types.put(h.getImportType(), h);
    }

    static TypeHandler get(String type) {
        return types.get(type);
    }

    static {
        types.put("int", new IntHandler());
        types.put("long", new PLongHandler());
        types.put("float", new PFloatHandler());
        types.put("boolean", new BoolHandler());
        types.put("java.lang.String", new StringHandler());
        types.put("java.lang.Integer", new IntegerHandler());
        types.put("java.lang.Long", new LongHandler());
        types.put("java.lang.Float", new FloatHandler());
        types.put("java.lang.Boolean", new BooleanHandler());
        TypeMap.add(new UuidHandler());
        TypeMap.add(new BigDecimalHandler());
        TypeMap.add(new LocalDateHandler());
        TypeMap.add(new LocalTimeHandler());
        TypeMap.add(new LocalDateTimeHandler());
        TypeMap.add(new InstantHandler());
        TypeMap.add(new OffsetDateTimeHandler());
    }

    static abstract class ObjectHandler
    implements TypeHandler {
        private final String importType;
        private final String shortName;
        private final String asMethod;
        private final String toMethod;

        ObjectHandler(String importType, String shortName) {
            this.importType = importType;
            this.shortName = shortName;
            this.asMethod = "as" + shortName + "(";
            this.toMethod = "to" + shortName + "(";
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public String getImportType() {
            return this.importType;
        }

        @Override
        public String shortName() {
            return this.shortName;
        }

        @Override
        public String asMethod() {
            return this.asMethod;
        }

        @Override
        public String toMethod() {
            return this.toMethod;
        }
    }

    static class LocalDateTimeHandler
    extends ObjectHandler {
        LocalDateTimeHandler() {
            super("java.time.LocalDateTime", "LocalDateTime");
        }
    }

    static class LocalTimeHandler
    extends ObjectHandler {
        LocalTimeHandler() {
            super("java.time.LocalTime", "LocalTime");
        }
    }

    static class OffsetDateTimeHandler
    extends ObjectHandler {
        OffsetDateTimeHandler() {
            super("java.time.OffsetDateTime", "OffsetDateTime");
        }
    }

    static class InstantHandler
    extends ObjectHandler {
        InstantHandler() {
            super("java.time.Instant", "Instant");
        }
    }

    static class LocalDateHandler
    extends ObjectHandler {
        LocalDateHandler() {
            super("java.time.LocalDate", "LocalDate");
        }
    }

    static class BigDecimalHandler
    extends ObjectHandler {
        BigDecimalHandler() {
            super("java.math.BigDecimal", "BigDecimal");
        }
    }

    static class UuidHandler
    extends ObjectHandler {
        UuidHandler() {
            super("java.util.UUID", "UUID");
        }
    }

    static abstract class Primitive
    implements TypeHandler {
        private final String type;
        private final String asMethod;

        Primitive(String asType) {
            this.asMethod = "as" + asType + "(";
            this.type = asType.toLowerCase();
        }

        Primitive(String asMethod, String type) {
            this.asMethod = asMethod;
            this.type = type;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public String shortName() {
            return this.type;
        }

        @Override
        public String asMethod() {
            return this.asMethod;
        }

        @Override
        public String toMethod() {
            return this.asMethod;
        }

        @Override
        public String getImportType() {
            return null;
        }
    }

    static abstract class JavaLangType
    implements TypeHandler {
        final String shortName;

        JavaLangType(String shortName) {
            this.shortName = shortName;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public String shortName() {
            return this.shortName;
        }

        @Override
        public String getImportType() {
            return null;
        }
    }

    static class BoolHandler
    extends Primitive {
        BoolHandler() {
            super("asBool(", "boolean");
        }
    }

    static class BooleanHandler
    extends JavaLangType {
        BooleanHandler() {
            super("Boolean");
        }

        @Override
        public String asMethod() {
            return "asBool(";
        }

        @Override
        public String toMethod() {
            return "toBoolean(";
        }
    }

    static class PFloatHandler
    extends Primitive {
        PFloatHandler() {
            super("Float");
        }
    }

    static class FloatHandler
    extends JavaLangType {
        FloatHandler() {
            super("Float");
        }

        @Override
        public String asMethod() {
            return "asFloat(";
        }

        @Override
        public String toMethod() {
            return "toFloat(";
        }
    }

    static class PLongHandler
    extends Primitive {
        PLongHandler() {
            super("Long");
        }
    }

    static class LongHandler
    extends JavaLangType {
        LongHandler() {
            super("Long");
        }

        @Override
        public String asMethod() {
            return "asLong(";
        }

        @Override
        public String toMethod() {
            return "toLong(";
        }
    }

    static class IntHandler
    extends Primitive {
        IntHandler() {
            super("Int");
        }
    }

    static class IntegerHandler
    extends JavaLangType {
        IntegerHandler() {
            super("Integer");
        }

        @Override
        public String asMethod() {
            return "asInteger(";
        }

        @Override
        public String toMethod() {
            return "toInteger(";
        }
    }

    static class StringHandler
    extends JavaLangType {
        StringHandler() {
            super("String");
        }

        @Override
        public String asMethod() {
            return null;
        }

        @Override
        public String toMethod() {
            return null;
        }
    }
}

