/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.openapi.DocContext;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class ProcessingContext {
    private final PlatformAdapter readAdapter;
    private final Messager messager;
    private final Filer filer;
    private final Elements elements;
    private final Types types;
    private final boolean openApiAvailable;
    private final DocContext docContext;

    ProcessingContext(ProcessingEnvironment env, PlatformAdapter readAdapter) {
        this.readAdapter = readAdapter;
        this.messager = env.getMessager();
        this.filer = env.getFiler();
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.openApiAvailable = this.isTypeAvailable("io.swagger.v3.oas.annotations.OpenAPIDefinition");
        this.docContext = new DocContext(env, this.openApiAvailable);
    }

    private boolean isTypeAvailable(String canonicalName) {
        return null != this.getTypeElement(canonicalName);
    }

    public TypeElement getTypeElement(String canonicalName) {
        return this.elements.getTypeElement(canonicalName);
    }

    public boolean isOpenApiAvailable() {
        return this.openApiAvailable;
    }

    public void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public JavaFileObject createWriter(String cls, Element origin) throws IOException {
        return this.filer.createSourceFile(cls, origin);
    }

    public String getDocComment(Element param) {
        return this.elements.getDocComment(param);
    }

    public DocContext doc() {
        return this.docContext;
    }

    public Element asElement(TypeMirror typeMirror) {
        return this.types.asElement(typeMirror);
    }

    public TypeMirror asMemberOf(DeclaredType declaredType, Element element) {
        return this.types.asMemberOf(declaredType, element);
    }

    public PlatformAdapter platform() {
        return this.readAdapter;
    }
}

