/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.api.Delete;
import io.avaje.http.api.Form;
import io.avaje.http.api.Get;
import io.avaje.http.api.Patch;
import io.avaje.http.api.Post;
import io.avaje.http.api.Produces;
import io.avaje.http.api.Put;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.MethodParam;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.PathSegments;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.WebMethod;
import io.avaje.http.generator.core.javadoc.Javadoc;
import io.avaje.http.generator.core.openapi.MethodDocBuilder;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class MethodReader {
    private final ProcessingContext ctx;
    private final ControllerReader bean;
    private final ExecutableElement element;
    private final boolean isVoid;
    private final List<MethodParam> params = new ArrayList<MethodParam>();
    private final Javadoc javadoc;
    private WebMethod webMethod;
    private String webMethodPath;
    private boolean formMarker;
    private final List<String> methodRoles;
    private final String produces;
    private final ExecutableType actualExecutable;
    private final List<? extends TypeMirror> actualParams;
    private final PathSegments pathSegments;

    MethodReader(ControllerReader bean, ExecutableElement element, ExecutableType actualExecutable, ProcessingContext ctx) {
        this.ctx = ctx;
        this.bean = bean;
        this.element = element;
        this.actualExecutable = actualExecutable;
        this.actualParams = actualExecutable == null ? null : actualExecutable.getParameterTypes();
        this.isVoid = element.getReturnType().getKind() == TypeKind.VOID;
        this.methodRoles = Util.findRoles(element);
        this.javadoc = Javadoc.parse(ctx.getDocComment(element));
        this.produces = this.produces(bean);
        this.initWebMethodViaAnnotation();
        this.pathSegments = this.isWebMethod() ? PathSegments.parse(Util.combinePath(bean.getPath(), this.webMethodPath)) : null;
    }

    private void initWebMethodViaAnnotation() {
        Get get;
        Form form = this.findAnnotation(Form.class);
        if (form != null) {
            this.formMarker = true;
        }
        if ((get = this.findAnnotation(Get.class)) != null) {
            this.initSetWebMethod(WebMethod.GET, get.value());
            return;
        }
        Put put = this.findAnnotation(Put.class);
        if (put != null) {
            this.initSetWebMethod(WebMethod.PUT, put.value());
            return;
        }
        Post post = this.findAnnotation(Post.class);
        if (post != null) {
            this.initSetWebMethod(WebMethod.POST, post.value());
            return;
        }
        Patch patch = this.findAnnotation(Patch.class);
        if (patch != null) {
            this.initSetWebMethod(WebMethod.PATCH, patch.value());
            return;
        }
        Delete delete = this.findAnnotation(Delete.class);
        if (delete != null) {
            this.initSetWebMethod(WebMethod.DELETE, delete.value());
        }
    }

    private void initSetWebMethod(WebMethod webMethod, String value) {
        this.webMethod = webMethod;
        this.webMethodPath = value;
    }

    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    private String produces(ControllerReader bean) {
        Produces produces = this.findAnnotation(Produces.class);
        return produces != null ? produces.value() : bean.getProduces();
    }

    public <A extends Annotation> A findAnnotation(Class<A> type) {
        A annotation = this.element.getAnnotation(type);
        if (annotation != null) {
            return annotation;
        }
        return this.bean.findMethodAnnotation(type, this.element);
    }

    private List<String> addTagsToList(Element element, List<String> list) {
        if (element == null) {
            return list;
        }
        if (element.getAnnotation(Tag.class) != null) {
            list.add(element.getAnnotation(Tag.class).name());
        }
        if (element.getAnnotation(Tags.class) != null) {
            for (Tag tag : element.getAnnotation(Tags.class).value()) {
                list.add(tag.name());
            }
        }
        return list;
    }

    public List<String> getTags() {
        List<String> tags = new ArrayList<String>();
        tags = this.addTagsToList(this.element, tags);
        return this.addTagsToList(this.element.getEnclosingElement(), tags);
    }

    void read() {
        if (!this.methodRoles.isEmpty()) {
            this.ctx.platform().methodRoles(this.methodRoles, this.bean);
        }
        ParamType defaultParamType = this.formMarker ? ParamType.FORMPARAM : ParamType.QUERYPARAM;
        List<? extends VariableElement> parameters = this.element.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement p = parameters.get(i);
            String rawType = this.actualParams != null ? Util.typeDef(this.actualParams.get(i)) : Util.typeDef(p.asType());
            MethodParam param = new MethodParam(p, rawType, this.ctx, defaultParamType, this.formMarker);
            this.params.add(param);
            param.addImports(this.bean);
        }
    }

    public void buildApiDoc() {
        this.buildApiDocumentation(this.ctx);
    }

    public void buildApiDocumentation(ProcessingContext ctx) {
        new MethodDocBuilder(this, ctx.doc()).build();
    }

    public List<String> roles() {
        return this.methodRoles.isEmpty() ? this.bean.getRoles() : this.methodRoles;
    }

    public boolean isWebMethod() {
        return this.webMethod != null;
    }

    public WebMethod getWebMethod() {
        return this.webMethod;
    }

    public List<MethodParam> getParams() {
        return this.params;
    }

    public boolean isVoid() {
        return this.isVoid;
    }

    public String getProduces() {
        return this.produces;
    }

    public TypeMirror getReturnType() {
        if (this.actualExecutable != null) {
            return this.actualExecutable.getReturnType();
        }
        return this.element.getReturnType();
    }

    public String getStatusCode() {
        return Integer.toString(this.webMethod.statusCode(this.isVoid));
    }

    public PathSegments getPathSegments() {
        return this.pathSegments;
    }

    public String getFullPath() {
        return this.pathSegments.fullPath();
    }

    public boolean includeValidate() {
        return this.bean.isIncludeValidator() && this.webMethod != WebMethod.GET;
    }

    public String simpleName() {
        return this.element.getSimpleName().toString();
    }

    public boolean isFormBody() {
        for (MethodParam param : this.params) {
            if (!param.isForm()) continue;
            return true;
        }
        return false;
    }

    public String getBodyType() {
        for (MethodParam param : this.params) {
            if (!param.isBody()) continue;
            return param.getShortType();
        }
        return null;
    }

    public String getBodyName() {
        for (MethodParam param : this.params) {
            if (!param.isBody()) continue;
            return param.getName();
        }
        return "body";
    }
}

