/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.api.BeanParam;
import io.avaje.http.api.Cookie;
import io.avaje.http.api.Default;
import io.avaje.http.api.Form;
import io.avaje.http.api.FormParam;
import io.avaje.http.api.Header;
import io.avaje.http.api.QueryParam;
import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.BeanParamReader;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.PathSegments;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.TypeHandler;
import io.avaje.http.generator.core.TypeMap;
import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.openapi.MethodDocBuilder;
import io.avaje.http.generator.core.openapi.MethodParamDocBuilder;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jetbrains.annotations.NotNull;

public class ElementReader {
    private final ProcessingContext ctx;
    private final Element element;
    private final String rawType;
    private final String shortType;
    private final TypeHandler typeHandler;
    private final String varName;
    private final String snakeName;
    private final boolean formMarker;
    private final boolean contextType;
    private String paramName;
    private ParamType paramType;
    private boolean impliedParamType;
    private String paramDefault;
    private boolean notNullKotlin;

    ElementReader(Element element, ProcessingContext ctx, ParamType defaultType, boolean formMarker) {
        this(element, Util.typeDef(element.asType()), ctx, defaultType, formMarker);
    }

    ElementReader(Element element, String rawType, ProcessingContext ctx, ParamType defaultType, boolean formMarker) {
        this.ctx = ctx;
        this.element = element;
        this.rawType = rawType;
        this.shortType = Util.shortName(rawType);
        this.contextType = ctx.platform().isContextType(rawType);
        this.typeHandler = TypeMap.get(rawType);
        this.formMarker = formMarker;
        this.varName = element.getSimpleName().toString();
        this.snakeName = Util.snakeCase(this.varName);
        this.paramName = this.varName;
        if (!this.contextType) {
            this.readAnnotations(element, defaultType);
        } else {
            this.paramType = ParamType.CONTEXT;
        }
    }

    private void readAnnotations(Element element, ParamType defaultType) {
        Form form;
        this.notNullKotlin = element.getAnnotation(NotNull.class) != null;
        Default defaultVal = element.getAnnotation(Default.class);
        if (defaultVal != null) {
            this.paramDefault = defaultVal.value();
        }
        if ((form = element.getAnnotation(Form.class)) != null) {
            this.paramType = ParamType.FORM;
            return;
        }
        BeanParam beanParam = element.getAnnotation(BeanParam.class);
        if (beanParam != null) {
            this.paramType = ParamType.BEANPARAM;
            return;
        }
        QueryParam queryParam = element.getAnnotation(QueryParam.class);
        if (queryParam != null) {
            this.paramName = this.nameFrom(queryParam.value(), this.varName);
            this.paramType = ParamType.QUERYPARAM;
            return;
        }
        FormParam formParam = element.getAnnotation(FormParam.class);
        if (formParam != null) {
            this.paramName = this.nameFrom(formParam.value(), this.varName);
            this.paramType = ParamType.FORMPARAM;
            return;
        }
        Cookie cookieParam = element.getAnnotation(Cookie.class);
        if (cookieParam != null) {
            this.paramName = this.nameFrom(cookieParam.value(), this.varName);
            this.paramType = ParamType.COOKIE;
            this.paramDefault = null;
            return;
        }
        Header headerParam = element.getAnnotation(Header.class);
        if (headerParam != null) {
            this.paramName = this.nameFrom(headerParam.value(), Util.initcapSnake(this.snakeName));
            this.paramType = ParamType.HEADER;
            this.paramDefault = null;
            return;
        }
        if (this.paramType == null) {
            this.impliedParamType = true;
            this.paramType = this.typeHandler != null ? defaultType : (this.formMarker ? ParamType.FORM : ParamType.BODY);
        }
    }

    public String toString() {
        return this.varName + " type:" + this.rawType + " paramType:" + (Object)((Object)this.paramType) + " dft:" + this.paramDefault;
    }

    private String nameFrom(String name, String defaultName) {
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return defaultName;
    }

    public String getVarName() {
        return this.varName;
    }

    private boolean hasParamDefault() {
        return this.paramDefault != null && !this.paramDefault.isEmpty();
    }

    private boolean isPlatformContext() {
        return this.contextType;
    }

    private String platformVariable() {
        return this.ctx.platform().platformVariable(this.rawType);
    }

    private String shortType() {
        if (this.typeHandler != null) {
            return this.typeHandler.shortName();
        }
        return this.shortType;
    }

    void addImports(ControllerReader bean) {
        if (this.typeHandler != null) {
            String importType = this.typeHandler.getImportType();
            if (importType != null) {
                bean.addImportType(this.rawType);
            }
        } else {
            bean.addImportType(this.rawType);
        }
    }

    void writeParamName(Append writer) {
        if (this.isPlatformContext()) {
            writer.append(this.platformVariable());
        } else {
            writer.append(this.varName);
        }
    }

    void buildApiDocumentation(MethodDocBuilder methodDoc) {
        if (!this.isPlatformContext()) {
            new MethodParamDocBuilder(methodDoc, this).build();
        }
    }

    void writeValidate(Append writer) {
        if (!this.isPlatformContext() && this.typeHandler == null) {
            writer.append("validator.validate(%s);", this.varName).eol();
            writer.append("      ");
        }
    }

    void writeCtxGet(Append writer, PathSegments segments) {
        if (this.isPlatformContext()) {
            return;
        }
        if (this.paramType == ParamType.BODY && this.ctx.platform().isBodyMethodParam()) {
            return;
        }
        String shortType = this.shortType();
        writer.append("%s  %s %s = ", this.ctx.platform().indent(), shortType, this.varName);
        if (this.setValue(writer, segments, shortType)) {
            writer.append(";").eol();
        }
    }

    void setValue(Append writer) {
        this.setValue(writer, PathSegments.EMPTY, this.shortType());
    }

    private boolean setValue(Append writer, PathSegments segments, String shortType) {
        String asMethod;
        PathSegments.Segment segment;
        if (ParamType.FORM == this.paramType) {
            this.writeForm(writer, shortType, this.varName, ParamType.FORMPARAM);
            return false;
        }
        if (ParamType.BEANPARAM == this.paramType) {
            this.writeForm(writer, shortType, this.varName, ParamType.QUERYPARAM);
            return false;
        }
        if (this.impliedParamType && (segment = segments.segment(this.varName)) != null) {
            String asMethod2;
            boolean requiredParam = segment.isRequired(this.varName);
            String string = this.typeHandler == null ? null : (asMethod2 = requiredParam ? this.typeHandler.asMethod() : this.typeHandler.toMethod());
            if (asMethod2 != null) {
                writer.append(asMethod2);
            }
            segment.writeGetVal(writer, this.varName, this.ctx.platform());
            if (asMethod2 != null) {
                writer.append(")");
            }
            this.paramType = ParamType.PATHPARAM;
            return true;
        }
        String string = asMethod = this.typeHandler == null ? null : this.typeHandler.toMethod();
        if (asMethod != null) {
            writer.append(asMethod);
        }
        if (this.typeHandler == null) {
            writer.append(this.ctx.platform().bodyAsClass(shortType));
        } else if (this.hasParamDefault()) {
            this.ctx.platform().writeReadParameter(writer, this.paramType, this.paramName, this.paramDefault);
        } else {
            boolean checkNull;
            boolean bl = checkNull = this.notNullKotlin || this.paramType == ParamType.FORMPARAM && this.typeHandler.isPrimitive();
            if (checkNull) {
                writer.append("checkNull(");
            }
            this.ctx.platform().writeReadParameter(writer, this.paramType, this.paramName);
            if (checkNull) {
                writer.append(", \"%s\")", this.paramName);
            }
        }
        if (asMethod != null) {
            writer.append(")");
        }
        return true;
    }

    private void writeForm(Append writer, String shortType, String varName, ParamType defaultParamType) {
        TypeElement formBeanType = this.ctx.getTypeElement(this.rawType);
        BeanParamReader form = new BeanParamReader(this.ctx, formBeanType, varName, shortType, defaultParamType);
        form.write(writer);
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getShortType() {
        return this.shortType;
    }

    public String getRawType() {
        return this.rawType;
    }

    public Element getElement() {
        return this.element;
    }
}

