/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.api.Path;
import io.avaje.http.api.Produces;
import io.avaje.http.generator.core.MethodReader;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.RequestScopeTypes;
import io.avaje.http.generator.core.Util;
import io.swagger.v3.oas.annotations.Hidden;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.validation.Valid;

public class ControllerReader {
    private final ProcessingContext ctx;
    private final TypeElement beanType;
    private final List<Element> interfaces;
    private final List<ExecutableElement> interfaceMethods;
    private final List<String> roles;
    private final List<MethodReader> methods = new ArrayList<MethodReader>();
    private final Set<String> staticImportTypes = new TreeSet<String>();
    private final Set<String> importTypes = new TreeSet<String>();
    private final String produces;
    private final boolean includeValidator;
    private boolean requestScope;
    private boolean docHidden;

    ControllerReader(TypeElement beanType, ProcessingContext ctx) {
        this.beanType = beanType;
        this.ctx = ctx;
        this.interfaces = this.initInterfaces();
        this.interfaceMethods = this.initInterfaceMethods();
        this.roles = Util.findRoles(beanType);
        this.importTypes.add("io.avaje.http.api.Generated");
        if (ctx.isOpenApiAvailable()) {
            this.docHidden = this.initDocHidden();
        }
        this.includeValidator = this.initIncludeValidator();
        this.importTypes.add("jakarta.inject.Singleton");
        this.importTypes.add("io.avaje.http.api.*");
        this.importTypes.add(beanType.getQualifiedName().toString());
        if (this.includeValidator) {
            this.importTypes.add("io.avaje.http.api.Validator");
        }
        this.produces = this.initProduces();
    }

    private List<Element> initInterfaces() {
        ArrayList<Element> interfaces = new ArrayList<Element>();
        for (TypeMirror typeMirror : this.beanType.getInterfaces()) {
            Element ifaceElement = this.ctx.asElement(typeMirror);
            if (ifaceElement.getAnnotation(Path.class) == null) continue;
            interfaces.add(ifaceElement);
        }
        return interfaces;
    }

    private List<ExecutableElement> initInterfaceMethods() {
        ArrayList<ExecutableElement> ifaceMethods = new ArrayList<ExecutableElement>();
        for (Element anInterface : this.interfaces) {
            ifaceMethods.addAll(ElementFilter.methodsIn(anInterface.getEnclosedElements()));
        }
        return ifaceMethods;
    }

    private <A extends Annotation> A findAnnotation(Class<A> type) {
        A annotation = this.beanType.getAnnotation(type);
        if (annotation != null) {
            return annotation;
        }
        for (Element anInterface : this.interfaces) {
            annotation = anInterface.getAnnotation(type);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    <A extends Annotation> A findMethodAnnotation(Class<A> type, ExecutableElement element) {
        for (ExecutableElement interfaceMethod : this.interfaceMethods) {
            A annotation;
            if (!this.matchMethod(interfaceMethod, element) || (annotation = interfaceMethod.getAnnotation(type)) == null) continue;
            return annotation;
        }
        return null;
    }

    private boolean matchMethod(ExecutableElement interfaceMethod, ExecutableElement element) {
        return interfaceMethod.toString().equals(element.toString());
    }

    private String initProduces() {
        Produces produces = this.findAnnotation(Produces.class);
        return produces == null ? null : produces.value();
    }

    private boolean initDocHidden() {
        return this.findAnnotation(Hidden.class) != null;
    }

    private boolean initIncludeValidator() {
        return this.findAnnotation(Valid.class) != null;
    }

    String getProduces() {
        return this.produces;
    }

    TypeElement getBeanType() {
        return this.beanType;
    }

    public boolean isDocHidden() {
        return this.docHidden;
    }

    public boolean isIncludeValidator() {
        return this.includeValidator;
    }

    boolean isRequestScoped() {
        return this.requestScope;
    }

    void read() {
        if (!this.roles.isEmpty()) {
            this.ctx.platform().controllerRoles(this.roles, this);
        }
        for (Element element : this.beanType.getEnclosedElements()) {
            if (element.getKind() == ElementKind.METHOD) {
                this.readMethod((ExecutableElement)element);
                continue;
            }
            if (element.getKind() != ElementKind.FIELD) continue;
            this.readField(element);
        }
        this.readSuper(this.beanType);
    }

    private void readField(Element element) {
        if (!this.requestScope) {
            String rawType = element.asType().toString();
            this.requestScope = RequestScopeTypes.isRequestType(rawType);
        }
    }

    private void readSuper(TypeElement beanType) {
        TypeMirror superclass = beanType.getSuperclass();
        if (superclass.getKind() != TypeKind.NONE) {
            DeclaredType declaredType = (DeclaredType)superclass;
            Element superElement = this.ctx.asElement(superclass);
            if (!"java.lang.Object".equals(superElement.toString())) {
                for (Element element : superElement.getEnclosedElements()) {
                    if (element.getKind() == ElementKind.METHOD) {
                        this.readMethod((ExecutableElement)element, declaredType);
                        continue;
                    }
                    if (element.getKind() != ElementKind.FIELD) continue;
                    this.readField(element);
                }
                if (superElement instanceof TypeElement) {
                    this.readSuper((TypeElement)superElement);
                }
            }
        }
    }

    private void readMethod(ExecutableElement element) {
        this.readMethod(element, null);
    }

    private void readMethod(ExecutableElement method, DeclaredType declaredType) {
        MethodReader methodReader;
        ExecutableType actualExecutable = null;
        if (declaredType != null) {
            actualExecutable = (ExecutableType)this.ctx.asMemberOf(declaredType, method);
        }
        if ((methodReader = new MethodReader(this, method, actualExecutable, this.ctx)).isWebMethod()) {
            methodReader.read();
            this.methods.add(methodReader);
        }
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<MethodReader> getMethods() {
        return this.methods;
    }

    public String getPath() {
        Path path = this.findAnnotation(Path.class);
        if (path == null) {
            return null;
        }
        return Util.trimPath(path.value());
    }

    public void addImportType(String rawType) {
        this.importTypes.add(rawType);
    }

    public void addStaticImportType(String rawType) {
        this.staticImportTypes.add(rawType);
    }

    public Set<String> getStaticImportTypes() {
        return this.staticImportTypes;
    }

    public Set<String> getImportTypes() {
        return this.importTypes;
    }
}

