/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.ElementReader;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

class BeanParamReader {
    private final ProcessingContext ctx;
    private final String beanVarName;
    private final String beanShortType;
    private final TypeElement beanType;
    private final ParamType defaultParamType;
    private final Set<String> setterMethods = new HashSet<String>();
    private final Map<String, FieldReader> fieldMap = new LinkedHashMap<String, FieldReader>();
    private final List<ExecutableElement> constructors = new ArrayList<ExecutableElement>();

    BeanParamReader(ProcessingContext ctx, TypeElement beanType, String beanVarName, String beanShortType, ParamType defaultParamType) {
        this.ctx = ctx;
        this.beanType = beanType;
        this.beanVarName = beanVarName;
        this.beanShortType = beanShortType;
        this.defaultParamType = defaultParamType;
        this.read();
    }

    private void read() {
        for (Element element : this.beanType.getEnclosedElements()) {
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    this.constructors.add((ExecutableElement)element);
                    break;
                }
                case METHOD: {
                    this.readMethod(element);
                    break;
                }
                case FIELD: {
                    this.readField(element);
                }
            }
        }
    }

    private void readField(Element enclosedElement) {
        FieldReader field = new FieldReader(this.ctx, enclosedElement, this.defaultParamType);
        this.fieldMap.put(field.getVarName(), field);
    }

    private void readMethod(Element enclosedElement) {
        String simpleName = enclosedElement.getSimpleName().toString();
        if (simpleName.startsWith("set")) {
            this.setterMethods.add(simpleName);
        }
    }

    void write(Append writer) {
        writer.append(" new %s(", this.beanShortType);
        Set<String> constructorParams = this.writeConstructorParams(writer);
        writer.append(");").eol();
        for (String setterMethod : this.setterMethods) {
            FieldReader field;
            String propName = Util.propertyName(setterMethod);
            if (constructorParams.contains(propName) || (field = this.fieldMap.get(propName)) == null) continue;
            field.setUseSetter(setterMethod);
        }
        for (FieldReader field : this.fieldMap.values()) {
            if (field.isConstructorParam()) continue;
            field.writeSet(writer, this.beanVarName);
        }
        writer.eol();
    }

    private Set<String> writeConstructorParams(Append writer) {
        HashSet<String> paramsUsed = new HashSet<String>();
        if (this.constructors.size() == 1) {
            int count = 0;
            for (VariableElement variableElement : this.constructors.get(0).getParameters()) {
                String paramName = variableElement.getSimpleName().toString();
                FieldReader field = this.fieldMap.get(paramName);
                if (field == null) continue;
                if (count++ > 0) {
                    writer.append(", ");
                }
                writer.eol().append("        ");
                field.writeConstructorParam(writer);
                paramsUsed.add(paramName);
            }
            if (count > 0) {
                writer.eol().append("      ");
            }
        }
        return paramsUsed;
    }

    static class FieldReader {
        private final ProcessingContext ctx;
        private final ElementReader element;
        private String setterMethod;
        private boolean constructorParam;

        FieldReader(ProcessingContext ctx, Element enclosedElement, ParamType defaultParamType) {
            this.ctx = ctx;
            this.element = new ElementReader(enclosedElement, ctx, defaultParamType, false);
        }

        String getVarName() {
            return this.element.getVarName();
        }

        public String toString() {
            return this.element.toString();
        }

        void writeConstructorParam(Append writer) {
            this.constructorParam = true;
            this.element.setValue(writer);
        }

        boolean isConstructorParam() {
            return this.constructorParam;
        }

        void writeSet(Append writer, String beanVarName) {
            if (this.setterMethod != null) {
                writer.append("%s  %s.%s(", this.ctx.platform().indent(), beanVarName, this.setterMethod);
                this.element.setValue(writer);
                writer.append(");").eol();
            } else {
                writer.append("%s  %s.%s = ", this.ctx.platform().indent(), beanVarName, this.getVarName());
                this.element.setValue(writer);
                writer.append(";").eol();
            }
        }

        void setUseSetter(String setterMethod) {
            this.setterMethod = setterMethod;
        }
    }
}

