/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.api.Controller;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.ProcessingContext;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public abstract class BaseProcessor
extends AbstractProcessor {
    protected ProcessingContext ctx;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Controller.class.getCanonicalName());
        annotations.add(OpenAPIDefinition.class.getCanonicalName());
        return annotations;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.ctx = new ProcessingContext(processingEnv, this.providePlatformAdapter());
    }

    protected abstract PlatformAdapter providePlatformAdapter();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        if (this.ctx.isOpenApiAvailable()) {
            this.readOpenApiDefinition(round);
            this.readTagDefinitions(round);
        }
        Set<? extends Element> controllers = round.getElementsAnnotatedWith(Controller.class);
        for (Element element : controllers) {
            this.writeControllerAdapter(element);
        }
        if (round.processingOver()) {
            this.writeOpenAPI();
        }
        return false;
    }

    private void readOpenApiDefinition(RoundEnvironment round) {
        Set<? extends Element> elements = round.getElementsAnnotatedWith(OpenAPIDefinition.class);
        for (Element element : elements) {
            this.ctx.doc().readApiDefinition(element);
        }
    }

    private void readTagDefinitions(RoundEnvironment round) {
        Set<? extends Element> elements = round.getElementsAnnotatedWith(Tag.class);
        for (Element element : elements) {
            this.ctx.doc().addTagDefinition(element);
        }
        elements = round.getElementsAnnotatedWith(Tags.class);
        for (Element element : elements) {
            this.ctx.doc().addTagsDefinition(element);
        }
    }

    private void writeOpenAPI() {
        this.ctx.doc().writeApi();
    }

    private void writeControllerAdapter(Element controller) {
        if (controller instanceof TypeElement) {
            ControllerReader reader = new ControllerReader((TypeElement)controller, this.ctx);
            reader.read();
            try {
                this.writeControllerAdapter(this.ctx, reader);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.ctx.logError(reader.getBeanType(), "Failed to write $route class " + e, new Object[0]);
            }
        }
    }

    public abstract void writeControllerAdapter(ProcessingContext var1, ControllerReader var2) throws IOException;
}

