/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.ProcessingContext;
import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

public abstract class BaseControllerWriter {
    protected final ControllerReader reader;
    protected final ProcessingContext ctx;
    protected final String originName;
    protected final String shortName;
    protected final String fullName;
    protected final String packageName;
    protected Append writer;

    public BaseControllerWriter(ControllerReader reader, ProcessingContext ctx) throws IOException {
        this.reader = reader;
        this.ctx = ctx;
        TypeElement origin = reader.getBeanType();
        this.originName = origin.getQualifiedName().toString();
        this.shortName = origin.getSimpleName().toString();
        this.fullName = this.originName + "$route";
        this.packageName = this.initPackageName(this.originName);
        this.initWriter();
    }

    protected boolean isRequestScoped() {
        return this.reader.isRequestScoped();
    }

    protected String initPackageName(String originName) {
        int dp = originName.lastIndexOf(46);
        return dp > -1 ? originName.substring(0, dp) : null;
    }

    protected void initWriter() throws IOException {
        this.writer = new Append(this.createFileWriter());
    }

    protected Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.ctx.createWriter(this.fullName, this.reader.getBeanType());
        return jfo.openWriter();
    }

    protected void writePackage() {
        if (this.packageName != null) {
            this.writer.append("package %s;", this.packageName).eol().eol();
        }
    }

    protected void writeImports() {
        this.writer.append("import static io.avaje.http.api.PathTypeConversion.*;").eol();
        for (String type : this.reader.getStaticImportTypes()) {
            this.writer.append("import static %s;", type).eol();
        }
        this.writer.eol();
        for (String type : this.reader.getImportTypes()) {
            this.writer.append("import %s;", type).eol();
        }
        this.writer.eol();
    }

    protected void writeClassEnd() {
        this.writer.append("}").eol();
        this.writer.close();
    }
}

