/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.applog;

import java.util.ResourceBundle;
import java.util.ServiceLoader;

public final class AppLog {
    private static final Provider provider = ServiceLoader.load(Provider.class).findFirst().orElseGet(() -> new DefaultProvider());

    private AppLog() {
    }

    public static System.Logger getLogger(String name) {
        return provider.getLogger(name);
    }

    public static System.Logger getLogger(Class<?> cls) {
        return provider.getLogger(cls.getName());
    }

    public static System.Logger getLogger(String name, ResourceBundle bundle) {
        return provider.getLogger(name, bundle);
    }

    public static interface Provider {
        public System.Logger getLogger(String var1);

        public System.Logger getLogger(String var1, ResourceBundle var2);
    }

    private static final class DefaultProvider
    implements Provider {
        private DefaultProvider() {
        }

        @Override
        public System.Logger getLogger(String name) {
            return System.getLogger(name);
        }

        @Override
        public System.Logger getLogger(String name, ResourceBundle bundle) {
            return System.getLogger(name, bundle);
        }
    }
}

