/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import io.atomix.utils.concurrent.BlockingAwareThreadPoolContext;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.Threads;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class BlockingAwareThreadPoolContextFactory
implements ThreadContextFactory {
    private final ScheduledExecutorService executor;

    public BlockingAwareThreadPoolContextFactory(String name, int threadPoolSize, Logger logger) {
        this(threadPoolSize, Threads.namedThreads(name, logger));
    }

    public BlockingAwareThreadPoolContextFactory(int threadPoolSize, ThreadFactory threadFactory) {
        this(Executors.newScheduledThreadPool(threadPoolSize, threadFactory));
    }

    public BlockingAwareThreadPoolContextFactory(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public ThreadContext createContext() {
        return new BlockingAwareThreadPoolContext(this.executor);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }
}

