/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import com.google.common.base.Preconditions;
import io.atomix.utils.concurrent.AbstractThreadContext;
import io.atomix.utils.concurrent.AtomixThread;
import io.atomix.utils.concurrent.Scheduled;
import java.time.Duration;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolContext
extends AbstractThreadContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolContext.class);
    protected final ScheduledExecutorService parent;
    private final Runnable runner;
    private final LinkedList<Runnable> tasks = new LinkedList();
    private boolean running;
    private final Executor executor = new Executor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            LinkedList linkedList = ThreadPoolContext.this.tasks;
            synchronized (linkedList) {
                ThreadPoolContext.this.tasks.add(command);
                if (!ThreadPoolContext.this.running) {
                    ThreadPoolContext.this.running = true;
                    ThreadPoolContext.this.parent.execute(ThreadPoolContext.this.runner);
                }
            }
        }
    };

    public ThreadPoolContext(ScheduledExecutorService parent) {
        this.parent = (ScheduledExecutorService)Preconditions.checkNotNull((Object)parent, (Object)"parent cannot be null");
        this.runner = () -> {
            ((AtomixThread)Thread.currentThread()).setContext(this);
            while (true) {
                Runnable task;
                LinkedList<Runnable> linkedList = this.tasks;
                synchronized (linkedList) {
                    task = this.tasks.poll();
                    if (task == null) {
                        this.running = false;
                        return;
                    }
                }
                try {
                    task.run();
                }
                catch (Throwable t) {
                    LOGGER.error("An uncaught exception occurred", t);
                    throw t;
                }
            }
        };
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public Scheduled schedule(Duration delay, Runnable runnable) {
        ScheduledFuture<?> future = this.parent.schedule(() -> this.executor.execute(runnable), delay.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public Scheduled schedule(Duration delay, Duration interval, Runnable runnable) {
        ScheduledFuture<?> future = this.parent.scheduleAtFixedRate(() -> this.executor.execute(runnable), delay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public void close() {
    }
}

