/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.memory;

import io.atomix.utils.memory.HeapMemoryAllocator;
import io.atomix.utils.memory.Memory;
import io.atomix.utils.memory.NativeMemory;
import sun.misc.Unsafe;

public class HeapMemory
implements Memory {
    public static final int ARRAY_BASE_OFFSET = NativeMemory.UNSAFE.arrayBaseOffset(byte[].class);
    public static final int MAX_SIZE = Integer.MAX_VALUE;
    private final HeapMemoryAllocator allocator;
    private byte[] array;

    public static HeapMemory allocate(int size) {
        return new HeapMemoryAllocator().allocate(size);
    }

    public static HeapMemory wrap(byte[] bytes) {
        return new HeapMemory(bytes, new HeapMemoryAllocator());
    }

    public HeapMemory(byte[] array, HeapMemoryAllocator allocator) {
        if (array == null) {
            throw new NullPointerException("array cannot be null");
        }
        if (allocator == null) {
            throw new NullPointerException("allocator cannot be null");
        }
        this.allocator = allocator;
        this.array = array;
    }

    @Override
    public HeapMemoryAllocator allocator() {
        return this.allocator;
    }

    @Override
    public final long address() {
        throw new UnsupportedOperationException();
    }

    public HeapMemory reset(byte[] array) {
        this.array = array;
        return this;
    }

    @Override
    public final long address(int offset) {
        return ARRAY_BASE_OFFSET + offset;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    public Unsafe unsafe() {
        return NativeMemory.UNSAFE;
    }

    public final byte[] array() {
        return this.array;
    }

    public final int offset() {
        return ARRAY_BASE_OFFSET;
    }

    @Override
    public HeapMemory copy() {
        HeapMemory copy = this.allocator.allocate(this.array.length);
        NativeMemory.UNSAFE.copyMemory(this.array, ARRAY_BASE_OFFSET, copy.array, ARRAY_BASE_OFFSET, this.array.length);
        return copy;
    }

    @Override
    public byte getByte(int offset) {
        return NativeMemory.UNSAFE.getByte(this.array, this.address(offset));
    }

    @Override
    public char getChar(int offset) {
        if (NativeMemory.BIG_ENDIAN) {
            return NativeMemory.UNSAFE.getChar(this.array, this.address(offset));
        }
        return Character.reverseBytes(NativeMemory.UNSAFE.getChar(this.array, this.address(offset)));
    }

    @Override
    public short getShort(int offset) {
        if (NativeMemory.BIG_ENDIAN) {
            return NativeMemory.UNSAFE.getShort(this.array, this.address(offset));
        }
        return Short.reverseBytes(NativeMemory.UNSAFE.getShort(this.array, this.address(offset)));
    }

    @Override
    public int getInt(int offset) {
        if (NativeMemory.BIG_ENDIAN) {
            return NativeMemory.UNSAFE.getInt(this.array, this.address(offset));
        }
        return Integer.reverseBytes(NativeMemory.UNSAFE.getInt(this.array, this.address(offset)));
    }

    @Override
    public long getLong(int offset) {
        if (NativeMemory.BIG_ENDIAN) {
            return NativeMemory.UNSAFE.getLong(this.array, this.address(offset));
        }
        return Long.reverseBytes(NativeMemory.UNSAFE.getLong(this.array, this.address(offset)));
    }

    @Override
    public float getFloat(int offset) {
        if (NativeMemory.BIG_ENDIAN) {
            return NativeMemory.UNSAFE.getFloat(this.array, this.address(offset));
        }
        return Float.intBitsToFloat(NativeMemory.UNSAFE.getInt(this.array, this.address(offset)));
    }

    @Override
    public double getDouble(int offset) {
        if (NativeMemory.BIG_ENDIAN) {
            return NativeMemory.UNSAFE.getDouble(this.array, this.address(offset));
        }
        return Double.longBitsToDouble(NativeMemory.UNSAFE.getLong(this.array, this.address(offset)));
    }

    @Override
    public void putByte(int offset, byte b) {
        NativeMemory.UNSAFE.putByte(this.array, this.address(offset), b);
    }

    @Override
    public void putChar(int offset, char c) {
        if (NativeMemory.BIG_ENDIAN) {
            NativeMemory.UNSAFE.putChar(this.array, this.address(offset), c);
        } else {
            NativeMemory.UNSAFE.putChar(this.array, this.address(offset), Character.reverseBytes(c));
        }
    }

    @Override
    public void putShort(int offset, short s) {
        if (NativeMemory.BIG_ENDIAN) {
            NativeMemory.UNSAFE.putShort(this.array, this.address(offset), s);
        } else {
            NativeMemory.UNSAFE.putShort(this.array, this.address(offset), Short.reverseBytes(s));
        }
    }

    @Override
    public void putInt(int offset, int i) {
        if (NativeMemory.BIG_ENDIAN) {
            NativeMemory.UNSAFE.putInt(this.array, this.address(offset), i);
        } else {
            NativeMemory.UNSAFE.putInt(this.array, this.address(offset), Integer.reverseBytes(i));
        }
    }

    @Override
    public void putLong(int offset, long l) {
        if (NativeMemory.BIG_ENDIAN) {
            NativeMemory.UNSAFE.putLong(this.array, this.address(offset), l);
        } else {
            NativeMemory.UNSAFE.putLong(this.array, this.address(offset), Long.reverseBytes(l));
        }
    }

    @Override
    public void putFloat(int offset, float f) {
        if (NativeMemory.BIG_ENDIAN) {
            NativeMemory.UNSAFE.putFloat(this.array, this.address(offset), f);
        } else {
            NativeMemory.UNSAFE.putInt(this.array, this.address(offset), Float.floatToIntBits(f));
        }
    }

    @Override
    public void putDouble(int offset, double d) {
        if (NativeMemory.BIG_ENDIAN) {
            NativeMemory.UNSAFE.putDouble(this.array, this.address(offset), d);
        } else {
            NativeMemory.UNSAFE.putLong(this.array, this.address(offset), Double.doubleToLongBits(d));
        }
    }

    @Override
    public void clear() {
        NativeMemory.UNSAFE.setMemory(this.array, ARRAY_BASE_OFFSET, this.array.length, (byte)0);
    }

    @Override
    public void free() {
        this.clear();
    }
}

